/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.CommandLineArg;
import java.util.ArrayList;

public class CommandLine {
    ArrayList<CommandLineArg> argList;
    String[] rawCommandLine;
    int nArgs = 0;
    private int rawArgs = 0;
    private int currentArg = -1;

    public CommandLine(String[] args) {
        if (args == null) {
            this.rawCommandLine = null;
            this.rawArgs = 0;
        } else {
            this.rawArgs = args.length;
            this.rawCommandLine = new String[this.rawArgs];
            int i = 0;
            while (i < this.rawArgs) {
                this.rawCommandLine[i] = args[i];
                this.argList = new ArrayList(this.rawArgs);
                ++i;
            }
            this.parse();
        }
    }

    private void parse() {
        int processed = 0;
        char arg = '\u0000';
        char switchChar = '\u0000';
        String paramStr = null;
        this.argList.add(new CommandLineArg(this.rawCommandLine[processed++]));
        ++this.nArgs;
        while (processed < this.rawArgs) {
            String argString;
            if ((arg = (argString = this.rawCommandLine[processed++]).charAt(0)) != '-' || argString.length() < 2) continue;
            arg = argString.charAt(1);
            if (argString.length() == 3) {
                switchChar = argString.charAt(2);
            } else if (argString.length() > 3) {
                switchChar = '\u0000';
                paramStr = argString.substring(2);
            } else {
                switchChar = '\u0000';
            }
            if (processed < this.rawArgs) {
                paramStr = this.rawCommandLine[processed].charAt(0) != '-' ? this.rawCommandLine[processed++] : null;
            }
            this.argList.add(new CommandLineArg(arg, switchChar, paramStr));
            ++this.nArgs;
        }
    }

    public int getNArgs() {
        return this.nArgs;
    }

    public CommandLineArg getFilename() {
        if (this.nArgs == 0) {
            return null;
        }
        if (this.currentArg == -1) {
            ++this.currentArg;
        }
        return this.argList.get(0);
    }

    public CommandLineArg getNextArg() {
        if (this.nArgs <= this.currentArg + 1) {
            return null;
        }
        ++this.currentArg;
        return this.argList.get(this.currentArg);
    }

    public CommandLineArg findArg(char flag) {
        CommandLineArg found = null;
        int holdPlace = this.currentArg;
        this.currentArg = -1;
        while ((found = this.getNextArg()) != null) {
            if (found.getFlag() != flag) continue;
            this.currentArg = holdPlace;
            break;
        }
        return found;
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        CommandLineArg cla = null;
        int numberOfArgs = cl.getNArgs();
        System.out.println("Number of Arguments: " + numberOfArgs);
        char flag = '\u0000';
        char sc = '\u0000';
        String textArg = null;
        int argNum = 0;
        while ((cla = cl.getNextArg()) != null) {
            System.out.println("Argument #" + argNum++);
            flag = cla.getFlag();
            if (flag != '\u0000') {
                System.out.println("\t" + flag);
            }
            if ((sc = cla.getSwitchChar()) != '\u0000') {
                System.out.println("\t" + sc);
            }
            if ((textArg = cla.getTextArg()) == null) continue;
            System.out.println("\t" + textArg);
        }
    }
}

