/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.PRCLineForm;
import com.fptech.xml.XSDMapping.filepro.fpXLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JOptionPane;

public class PRCTable
extends Box {
    private static final long serialVersionUID = 1L;
    private String prcName = null;
    boolean opened = false;
    fpXLog log = null;
    int numLines = 0;
    ArrayList<PRCLineForm> formList;

    public PRCTable(int orientation, String pname, fpXLog log) {
        super(orientation);
        this.prcName = pname;
        this.log = log;
        ArrayList<String> tableContent = this.prcOpen(this.prcName);
        if (tableContent == null) {
            this.opened = false;
        } else {
            this.opened = true;
            this.populate(tableContent);
            this.numLines = tableContent.size();
        }
    }

    public int getNumberOfLines() {
        return this.numLines;
    }

    private boolean isEncoded(String s) {
        boolean retval = false;
        int count = 0;
        int p = 0;
        while (p < s.length()) {
            if (s.charAt(p) == ':') {
                ++count;
            }
            ++p;
        }
        if (count < 3) {
            retval = true;
            if (this.log != null) {
                this.log.writeDebug("Processing line: " + s);
                this.log.writeDebug("Token count is " + count);
            }
        }
        return retval;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public String buildPRCName(String tableName) {
        String fullName = null;
        return fullName;
    }

    public static int getPrcLineHeight() {
        PRCLineForm testLine = new PRCLineForm(0, "a:b:c:");
        return testLine.getPreferredSize().height;
    }

    public ArrayList<String> prcOpen(String fName) {
        ArrayList<String> lines = new ArrayList<String>();
        File prcfile = new File(fName);
        if (!prcfile.canRead()) {
            JOptionPane.showMessageDialog(null, "Processing table " + fName + " can not be read.", "View Processing Table", 0);
            return null;
        }
        if (prcfile.length() == 0L) {
            JOptionPane.showMessageDialog(null, "Processing table " + fName + " is empty.", "View Processing Table", 0);
            return null;
        }
        try {
            String line;
            BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(prcfile)));
            while ((line = is.readLine()) != null) {
                if (this.isEncoded(line)) {
                    if (this.log != null) {
                        this.log.writeInfo("Processing table " + this.prcName + " is encoded.");
                    }
                    JOptionPane.showMessageDialog(null, "Processing table " + this.prcName + " is encoded.");
                    lines = null;
                    break;
                }
                lines.add(line);
            }
            is.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Open of processing table " + fName + " failed.", "View Processing Table", 0);
            return null;
        }
        return lines;
    }

    public ArrayList<PRCLineForm> getFormList() {
        return this.formList;
    }

    public void populate(ArrayList<String> lines) {
        PRCLineForm plf = null;
        this.formList = new ArrayList();
        int i = 0;
        while (i < lines.size()) {
            if (this.log != null) {
                this.log.writeDebug("Adding processing line " + lines.get(i) + " to form.");
            }
            plf = new PRCLineForm(i + 1, lines.get(i));
            this.formList.add(plf);
            this.add(plf);
            ++i;
        }
    }
}

