/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.fpXLog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;

public class fpConfig {
    private String pfProg = null;
    private String pfEnv = null;
    private String pfDir = null;
    private String pfData = null;
    private String pfDsk = null;
    private String pfConfig = null;
    private boolean testMode = false;
    private Properties FPPropTable;
    private Properties FPEnvTable;
    fpXLog log;
    private String dataDirectory = null;

    public fpConfig(fpXLog fplog) {
        this(false, fplog);
        this.log = fplog;
    }

    public fpConfig(fpConfig org, fpXLog fplog) {
        this.FPPropTable = new Properties(org.getPropTable());
        this.FPEnvTable = new Properties(org.getEnvTable());
        this.testMode = org.getMode();
        this.pfProg = org.getPFProg();
        this.pfEnv = org.getPFEnv();
        this.pfDir = org.getPFDir();
        this.pfData = org.getPFData();
        this.pfDsk = org.getPFDsk();
        this.pfConfig = org.getPFConfig();
        this.log = fplog;
    }

    public fpConfig(fpConfig org, boolean mode, fpXLog fplog) {
        this.FPPropTable = new Properties(org.getPropTable());
        this.FPEnvTable = new Properties(org.getEnvTable());
        this.testMode = mode;
        this.pfProg = org.getPFProg();
        this.pfEnv = org.getPFEnv();
        this.pfDir = org.getPFDir();
        this.pfData = org.getPFData();
        this.pfDsk = org.getPFDsk();
        this.pfConfig = org.getPFConfig();
        this.log = fplog;
    }

    public fpConfig(boolean mode, fpXLog fplog) {
        this.testMode = mode;
        this.log = fplog;
        this.FPPropTable = new Properties(System.getProperties());
        this.FPEnvTable = new Properties();
        this.pfEnv = System.getProperty("PFENV");
        if (this.pfEnv == null) {
            this.pfEnv = System.getProperty("FPENV");
        }
        if (this.pfEnv != null) {
            this.readInEnvFile(this.pfEnv);
        }
        this.pfProg = System.getenv("PFPROG");
        if (this.pfProg != null) {
            this.FPEnvTable.put("PFPROG", this.pfProg);
        }
        this.pfData = System.getenv("PFDATA");
        if (this.pfData != null) {
            this.FPEnvTable.put("PFDATA", this.pfData);
        }
        this.pfDir = System.getenv("PFDIR");
        if (this.pfDir != null) {
            this.FPEnvTable.put("PFDIR", this.pfDir);
        }
        this.pfDsk = System.getenv("PFDSK");
        if (this.pfDsk != null) {
            this.FPEnvTable.put("PFDSK", this.pfDsk);
        }
        this.readInFPPathFile();
        this.pfConfig = this.FPPropTable.getProperty("PFCONFIG");
        if (this.pfConfig == null) {
            this.pfConfig = this.FPPropTable.getProperty("FPCONFIG");
        }
        if (this.pfConfig == null) {
            this.pfConfig = this.pfProg != null ? String.valueOf(this.getPFProg()) + "/fp/lib/config" : "/fp/lib/config";
        }
        this.FPEnvTable.put("PFCONFIG", this.pfConfig);
        this.readInConfigFile(this.pfConfig);
    }

    static void infoMessage(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public String[] buildEnv() {
        Properties p = this.getEnvTable();
        int i = 0;
        Enumeration<?> names = p.propertyNames();
        while (names.hasMoreElements()) {
            ++i;
            names.nextElement();
        }
        int envsize = i;
        String[] builtEnv = new String[envsize];
        names = p.propertyNames();
        i = 0;
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String property = this.FPPropTable.getProperty("file.separator").equals("\\") ? p.getProperty(key).replace('/', '\\') : p.getProperty(key);
            builtEnv[i++] = new String(String.valueOf(key) + "=" + property);
        }
        return builtEnv;
    }

    public void putProperty(String name, String value) {
        if (name == null) {
            return;
        }
        String eName = name.trim();
        if (eName.length() <= 0) {
            return;
        }
        if (value == null) {
            this.FPEnvTable.remove(name);
            return;
        }
        String eValue = value.trim();
        eValue = eValue.replace('\\', '/');
        if (this.testMode) {
            System.out.println("Name: " + eName + " Value: " + eValue);
        } else {
            try {
                this.FPEnvTable.put(eName, eValue);
            }
            catch (NullPointerException e) {
                return;
            }
        }
    }

    public String getPFConfig() {
        return this.pfConfig;
    }

    public String getPFData() {
        return this.pfData;
    }

    public String getPFDir() {
        return this.pfDir;
    }

    public String getPFDsk() {
        return this.pfDsk;
    }

    public String getPFProg() {
        return this.pfProg;
    }

    private String getPFEnv() {
        return this.pfEnv;
    }

    public String getProgramDirectory() {
        StringBuffer progdir = new StringBuffer();
        if (this.pfProg == null) {
            if (fpConfig.isWindows()) {
                progdir.append(this.FPPropTable.getProperty("file.separator"));
                progdir.append("appl");
                progdir.append(this.FPPropTable.getProperty("file.separator"));
                progdir.append("fp");
            } else {
                progdir.append(this.FPPropTable.getProperty("file.separator"));
                progdir.append("appl");
                progdir.append(this.FPPropTable.getProperty("file.separator"));
                progdir.append("fp");
            }
        } else {
            progdir.append(this.pfProg);
            char lastChar = progdir.charAt(progdir.length() - 1);
            if (lastChar == '/' || lastChar == '\\') {
                progdir.append("fp");
            } else {
                progdir.append(this.FPPropTable.getProperty("file.separator"));
                progdir.append("fp");
            }
        }
        if (this.log != null) {
            this.log.writeDebug("Program directory is " + progdir.toString());
        }
        return progdir.toString();
    }

    private Properties getPropTable() {
        return this.FPPropTable;
    }

    private Properties getEnvTable() {
        return this.FPEnvTable;
    }

    private boolean getMode() {
        return this.testMode;
    }

    public boolean envBool(String eName, boolean eDefault) {
        String eValue = null;
        if (eName == null) {
            return eDefault;
        }
        eValue = this.envStr(eName, null);
        if (eValue == null) {
            return eDefault;
        }
        return (eValue = eValue.trim().toUpperCase()).equals("ON") || eValue.equals("YES") || eValue.equals("TRUE");
    }

    public int envNum(String eName, int eDefault) {
        String eValue = null;
        int retval = eDefault;
        if (eName == null) {
            return eDefault;
        }
        eValue = this.envStr(eName, null);
        if (eValue != null) {
            try {
                retval = eValue.startsWith("0x") ? Integer.parseInt(eValue, 16) : Integer.parseInt(eValue);
            }
            catch (NumberFormatException e) {
                return eDefault;
            }
        }
        return retval;
    }

    public String envStr(String eName, String sDefault) {
        if (eName == null) {
            return sDefault;
        }
        String eValue = System.getenv(eName.trim());
        if (eValue == null) {
            eValue = System.getenv("PF" + eName.trim());
        }
        if (eValue == null) {
            eValue = System.getenv("FP" + eName.trim());
        }
        if (eValue == null) {
            eValue = System.getenv(eName.trim());
        }
        if (this.FPEnvTable != null) {
            if (eValue == null) {
                eValue = this.FPEnvTable.getProperty("PF" + eName.trim());
            }
            if (eValue == null) {
                eValue = this.FPEnvTable.getProperty("FP" + eName.trim());
            }
            if (eValue == null) {
                eValue = this.FPEnvTable.getProperty(eName.trim());
            }
        }
        if (this.FPPropTable != null) {
            if (eValue == null) {
                eValue = this.FPPropTable.getProperty("PF" + eName.trim());
            }
            if (eValue == null) {
                eValue = this.FPPropTable.getProperty("FP" + eName.trim());
            }
            if (eValue == null) {
                eValue = this.FPPropTable.getProperty(eName.trim());
            }
        }
        if (eValue == null) {
            return sDefault;
        }
        return eValue;
    }

    public static String getTmpDirectory() {
        String retval = null;
        retval = System.getenv("PFTMP");
        if (retval == null) {
            System.getenv("FPTMP");
        }
        if (retval == null) {
            System.getenv("TMP");
        }
        if (retval == null) {
            System.getenv("TEMP");
        }
        if (retval == null) {
            retval = "/tmp";
        }
        return retval;
    }

    public void setDataDirectory(String dataDir) {
        dataDir.replace('\\', '/');
        this.dataDirectory = dataDir.endsWith("/") ? dataDir : String.valueOf(dataDir) + "/";
        if (this.log != null) {
            this.log.writeDebug("Data Directory set to " + this.dataDirectory);
        }
    }

    public String getDataDirectory() {
        StringBuffer datadir = new StringBuffer();
        if (this.dataDirectory != null) {
            return this.dataDirectory;
        }
        if (this.log != null) {
            this.log.writeDebug("Determining data directory");
        }
        if (this.pfDsk != null) {
            this.pfDsk.replace('\\', '/');
            datadir.append(this.pfDsk);
            if (!this.pfDsk.endsWith("/")) {
                if (this.pfDsk.endsWith(":")) {
                    datadir.append("/");
                } else if (fpConfig.isWindows()) {
                    datadir.append(":/");
                }
            }
        } else {
            datadir.append("/");
        }
        if (this.log != null) {
            this.log.writeDebug("Data directory after processing PFDSK " + datadir.toString());
        }
        if (this.pfData != null && !this.pfData.isEmpty()) {
            this.pfData.replace('\\', '/');
            if (this.pfData.startsWith("/")) {
                datadir.append(this.pfData.substring(1));
            } else {
                datadir.append(this.pfData);
            }
            if (!this.pfData.endsWith("/")) {
                datadir.append("/");
            }
        }
        if (this.log != null) {
            this.log.writeDebug("Data directory after processing PFDATA " + datadir.toString());
        }
        if (this.pfDir != null && !this.pfDir.isEmpty()) {
            this.pfDir.replace('\\', '/');
            this.log.writeDebug("pfDir is " + this.pfDir);
            if (this.pfDir.startsWith("/")) {
                datadir.append(this.pfDir.substring(1));
            } else {
                datadir.append(this.pfDir);
            }
            if (!this.pfDir.endsWith("/")) {
                datadir.append("/");
            }
        }
        if (this.log != null) {
            this.log.writeDebug("Data directory after processing PFDIR " + datadir.toString());
        }
        datadir.append("filepro/");
        if (this.log != null) {
            this.log.writeDebug("Data directory is returned as " + datadir.toString());
        }
        this.setDataDirectory(datadir.toString());
        return datadir.toString();
    }

    private void parseLine(String eLine, boolean toPropTable) {
        int idx = eLine.indexOf(61);
        if (idx == -1) {
            return;
        }
        String eName = eLine.substring(0, idx).trim();
        String eValue = eLine.substring(idx + 1).trim();
        if (eName.length() <= 0) {
            return;
        }
        String eProp = this.FPPropTable.getProperty(eName);
        if (eProp == null) {
            eValue = eValue.replace('\\', '/');
            if (this.testMode) {
                System.out.println("Name: " + eName + " Value: " + eValue);
            } else {
                try {
                    if (toPropTable) {
                        this.FPPropTable.put(eName, eValue);
                    } else {
                        this.FPPropTable.put(eName, eValue);
                        this.FPEnvTable.put(eName, eValue);
                    }
                }
                catch (NullPointerException e) {
                    return;
                }
            }
        }
    }

    private void readInFPPathFile() {
        String fileName = this.FPPropTable.getProperty("file.separator").equals("/") ? "/etc/default/fppath" : "/fppath";
        try {
            String dirLine;
            String dataLine;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String progLine = br.readLine();
            if (progLine != null && this.pfProg == null) {
                this.pfProg = progLine.trim();
            }
            if ((dataLine = br.readLine()) != null && this.pfData == null) {
                this.pfData = dataLine.trim();
            }
            if ((dirLine = br.readLine()) != null && this.pfDir == null) {
                this.pfDir = dirLine.trim();
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readInConfigFile(String fileName) {
        boolean more = true;
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while (more) {
                String envLine = br.readLine();
                if (envLine == null) {
                    more = false;
                    continue;
                }
                this.parseLine(envLine, false);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readInEnvFile(String fileName) {
        boolean more = true;
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while (more) {
                String envLine = br.readLine();
                if (envLine == null) {
                    more = false;
                    continue;
                }
                this.parseLine(envLine, false);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Env file " + fileName + " not found. " + e);
        }
        catch (IOException e1) {
            System.out.println("IO error reading " + fileName + ". " + e1);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

