/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.EditType;
import com.fptech.xml.XSDMapping.filepro.fpFormatException;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;

public class fpDate {
    GregorianCalendar cal = new GregorianCalendar();
    static int[] datePosition;
    static int[] monthPosition;
    static int[] yearPosition;
    static int[] yearLength;
    static int[] slash;
    static int[] spaceRequired;

    static {
        int[] nArray = new int[12];
        nArray[0] = 4;
        nArray[2] = 2;
        nArray[3] = 6;
        nArray[5] = 3;
        nArray[6] = 6;
        nArray[8] = 2;
        nArray[9] = 8;
        nArray[11] = 3;
        datePosition = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[6] = 4;
        nArray2[7] = 2;
        nArray2[9] = 5;
        nArray2[10] = 3;
        monthPosition = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = 4;
        nArray3[2] = 4;
        nArray3[4] = 6;
        nArray3[5] = 6;
        nArray3[7] = 4;
        nArray3[8] = 4;
        nArray3[10] = 6;
        nArray3[11] = 6;
        yearPosition = nArray3;
        yearLength = new int[]{2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4};
        int[] nArray4 = new int[12];
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[9] = 1;
        nArray4[10] = 1;
        nArray4[11] = 1;
        slash = nArray4;
        spaceRequired = new int[]{6, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10};
    }

    public void parse(String text) throws ParseException {
        EditType et = new EditType(23);
        this.parse(text, et);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String intext, EditType edtype) throws ParseException {
        if (intext == null) {
            Date today = new Date();
            this.cal.setTime(today);
            return;
        }
        String text = intext.trim();
        if (text.length() == 0 || text.charAt(0) == '/') {
            Date today = new Date();
            this.cal.setTime(today);
            return;
        }
        int dy = 0;
        int mn = 0;
        int yr = 0;
        int slashpos1 = text.indexOf(47);
        if (slashpos1 != -1) {
            String part1 = text.substring(0, slashpos1);
            int slashpos2 = text.indexOf(47, slashpos1 + 1);
            if (slashpos2 == -1) {
                throw new ParseException("Unparseable Date: \"" + text + "\"", 0);
            }
            String part2 = text.substring(slashpos1 + 1, slashpos2);
            String part3 = text.substring(slashpos2 + 1);
            if (edtype.getDateRelativePosition() == 0) {
                dy = Integer.parseInt(part1);
                mn = Integer.parseInt(part2);
                yr = Integer.parseInt(part3);
            } else if (edtype.getMonthRelativePosition() == 0) {
                dy = Integer.parseInt(part2);
                mn = Integer.parseInt(part1);
                yr = Integer.parseInt(part3);
            } else {
                dy = Integer.parseInt(part3);
                mn = Integer.parseInt(part2);
                yr = Integer.parseInt(part1);
            }
            if (yr < 100) {
                yr += 1900;
            }
            this.cal.set(yr, mn - 1, dy);
            return;
        } else {
            String part1;
            String part2;
            String part3;
            int tlen = text.length();
            if (edtype.getDateRelativePosition() == 0) {
                if (tlen == 5 || tlen == 7) {
                    part3 = text.substring(0, 1);
                    part2 = text.substring(1, 3);
                    part1 = text.substring(3);
                } else {
                    if (tlen != 6 && tlen != 8) throw new ParseException("Unparseable Date: \"" + text + "\"", 0);
                    part3 = text.substring(0, 2);
                    part2 = text.substring(2, 4);
                    part1 = text.substring(4);
                }
            } else if (edtype.getMonthRelativePosition() == 0) {
                if (tlen == 5 || tlen == 7) {
                    part2 = text.substring(0, 1);
                    part3 = text.substring(1, 3);
                    part1 = text.substring(3);
                }
                if (tlen != 6 && tlen != 8) throw new ParseException("Unparseable Date: \"" + text + "\"", 0);
                part2 = text.substring(0, 2);
                part3 = text.substring(2, 4);
                part1 = text.substring(4);
            } else if (tlen == 6) {
                part1 = text.substring(0, 2);
                part2 = text.substring(2, 4);
                part3 = text.substring(4);
            } else {
                if (text.length() != 8) throw new ParseException("Unparseable Date: \"" + text + "\"", 0);
                part1 = text.substring(0, 4);
                part2 = text.substring(4, 6);
                part3 = text.substring(6);
            }
            dy = Integer.parseInt(part3);
            mn = Integer.parseInt(part2);
            yr = Integer.parseInt(part1);
            if (yr < 100) {
                yr += 1900;
            }
            this.cal.set(yr, mn - 1, dy);
        }
    }

    public String format(EditType edtype) throws ParseException, fpFormatException {
        if (!edtype.isDateType()) {
            throw new fpFormatException("Invalid EditType for Dates");
        }
        int dateIndex = edtype.getType() - 21;
        int dateSize = spaceRequired[dateIndex];
        return this.format(edtype, dateSize);
    }

    public String format(EditType edtype, int outlen) throws ParseException, fpFormatException {
        if (!edtype.isDateType()) {
            throw new fpFormatException("Invalid EditType for Dates");
        }
        int dateIndex = edtype.getType() - 21;
        int dateSize = spaceRequired[dateIndex];
        if (outlen < dateSize) {
            throw new fpFormatException(dateSize);
        }
        StringBuffer sbDate = new StringBuffer(dateSize);
        char appendChar = ' ';
        if (slash[dateIndex] == 1) {
            appendChar = '/';
        }
        int i = 0;
        while (i < dateSize) {
            sbDate.append(appendChar);
            ++i;
        }
        int dayValue = this.cal.get(5);
        Integer iD = new Integer(dayValue);
        String sD = iD.toString();
        if (dayValue > 9) {
            sbDate.setCharAt(datePosition[dateIndex], sD.charAt(0));
            sbDate.setCharAt(datePosition[dateIndex] + 1, sD.charAt(1));
        } else {
            sbDate.setCharAt(datePosition[dateIndex], '0');
            sbDate.setCharAt(datePosition[dateIndex] + 1, sD.charAt(0));
        }
        int monthValue = this.cal.get(2) + 1;
        Integer iM = new Integer(monthValue);
        String sM = iM.toString();
        if (monthValue < 10) {
            sbDate.setCharAt(monthPosition[dateIndex], '0');
            sbDate.setCharAt(monthPosition[dateIndex] + 1, sM.charAt(0));
        } else {
            sbDate.setCharAt(monthPosition[dateIndex], sM.charAt(0));
            sbDate.setCharAt(monthPosition[dateIndex] + 1, sM.charAt(1));
        }
        int yearValue = this.cal.get(1);
        Integer iY = new Integer(yearValue);
        String sY = iY.toString();
        if (yearLength[dateIndex] == 4) {
            sbDate.setCharAt(yearPosition[dateIndex], sY.charAt(0));
            sbDate.setCharAt(yearPosition[dateIndex] + 1, sY.charAt(1));
            sbDate.setCharAt(yearPosition[dateIndex] + 2, sY.charAt(2));
            sbDate.setCharAt(yearPosition[dateIndex] + 3, sY.charAt(3));
        } else {
            sbDate.setCharAt(yearPosition[dateIndex], sY.charAt(2));
            sbDate.setCharAt(yearPosition[dateIndex] + 1, sY.charAt(3));
        }
        return sbDate.toString();
    }

    public static void main(String[] args) {
        fpDate testD = new fpDate();
        if (args.length == 1) {
            try {
                testD.parse(args[0]);
            }
            catch (ParseException e) {
                System.out.println("ParseException: " + e);
            }
        }
        try {
            String ymdTest = testD.format(new EditType(21));
            System.out.println("Today formatted as YMD is " + ymdTest);
            String dmyTest = testD.format(new EditType(22));
            System.out.println("      formatted as DMY is " + dmyTest);
            String mdyTest = testD.format(new EditType(23));
            System.out.println("      formatted as MDY is " + mdyTest);
            String symdTest = testD.format(new EditType(24));
            System.out.println("      formatted as S_YMD is " + symdTest);
            String sdmyTest = testD.format(new EditType(25));
            System.out.println("      formatted as S_DMY is " + sdmyTest);
            String smdyTest = testD.format(new EditType(26));
            System.out.println("      formatted as S_MDY is " + smdyTest);
            String yymdTest = testD.format(new EditType(27));
            System.out.println("      formatted as YYMD is " + yymdTest);
            String dmyyTest = testD.format(new EditType(28));
            System.out.println("      formatted as DMYY is " + dmyyTest);
            String mdyyTest = testD.format(new EditType(29));
            System.out.println("      formatted as MDYY is " + mdyyTest);
            String syymdTest = testD.format(new EditType(30));
            System.out.println("      formatted as S_YYMD is " + syymdTest);
            String sdmyyTest = testD.format(new EditType(31));
            System.out.println("      formatted as S_DMYY is " + sdmyyTest);
            String smdyyTest = testD.format(new EditType(32));
            System.out.println("      formatted as S_MDYY is " + smdyyTest);
        }
        catch (ParseException e) {
            System.out.println("ParseException: " + e);
        }
        catch (fpFormatException f) {
            System.out.println("fpFormatException " + f);
        }
    }
}

