/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.fpField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class fpFile {
    private File filedir;
    private fpField[] fields;
    private int keylength;
    private int datalength;
    private int current_record;
    private int number_of_fields;

    public fpFile(String dir, String name) {
        this.filedir = new File(dir, name);
        this.current_record = -1;
        this.open();
    }

    public boolean open() {
        StringTokenizer t;
        BufferedReader is;
        block6: {
            String line;
            block5: {
                this.current_record = 0;
                File mapfile = new File(this.filedir, "map");
                is = new BufferedReader(new InputStreamReader(new FileInputStream(mapfile)));
                line = is.readLine();
                if (line != null) break block5;
                is.close();
                return false;
            }
            t = new StringTokenizer(line, ":");
            String text = t.nextToken();
            if (text.equals("map")) break block6;
            is.close();
            return false;
        }
        try {
            this.keylength = Integer.parseInt(t.nextToken().trim());
            this.datalength = Integer.parseInt(t.nextToken().trim());
            this.number_of_fields = Integer.parseInt(t.nextToken().trim());
            this.fields = this.readFields(is);
            is.close();
        }
        catch (NumberFormatException nfe) {
            System.out.print("Error parsing map: " + nfe);
            return false;
        }
        catch (IOException e) {
            System.out.print("Error: " + e);
            return false;
        }
        return true;
    }

    fpField[] readFields(BufferedReader is) throws IOException {
        fpField[] f = new fpField[this.number_of_fields];
        int offset = 0;
        int i = 0;
        while (i < this.number_of_fields) {
            f[i] = new fpField("", 0, "", i + 1, 0);
            f[i].readMapField(is, offset);
            offset += f[i].getFieldLength();
            ++i;
        }
        return f;
    }

    public String getFileName() {
        return this.filedir.getName();
    }

    public int getKeyLength() {
        return this.keylength;
    }

    public int getDataLength() {
        return this.datalength;
    }

    public int getCurrentRecord() {
        return this.current_record;
    }

    public int getNumberOfFields() {
        return this.number_of_fields;
    }

    public fpField getField(int fldno) {
        if (fldno > this.number_of_fields) {
            return null;
        }
        if (this.fields == null) {
            return null;
        }
        return this.fields[fldno - 1];
    }
}

