/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.fpConfig;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class fpFormatFilter
extends FileFilter {
    int formatType;

    public fpFormatFilter(int type) {
        this.formatType = type;
    }

    @Override
    public boolean accept(File f) {
        boolean retval = false;
        if (this.formatType == 0) {
            if (!f.isDirectory()) {
                return false;
            }
            File mapFile = new File(f, "map");
            return mapFile.exists();
        }
        String fName = f.getName().toLowerCase();
        switch (this.formatType) {
            case 1: {
                if (!fName.startsWith("map") && !f.isDirectory()) break;
                retval = true;
                break;
            }
            case 2: {
                if (fpConfig.isWindows()) {
                    if (!fName.endsWith(".prc") && !f.isDirectory()) break;
                    retval = true;
                    break;
                }
                if (!fName.startsWith("prc.") && !f.isDirectory()) break;
                retval = true;
                break;
            }
            case 3: {
                if (fpConfig.isWindows()) {
                    if (!fName.endsWith(".fpx") && !f.isDirectory()) break;
                    retval = true;
                    break;
                }
                if (!fName.startsWith("fpx.") && !f.isDirectory()) break;
                retval = true;
                break;
            }
            default: {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public String getDescription() {
        String s = null;
        switch (this.formatType) {
            case 1: {
                s = "filePro map file";
                break;
            }
            case 2: {
                s = "filePro processing file";
                break;
            }
            case 3: {
                s = "filePro xsd mapping file";
            }
        }
        return s;
    }
}

