/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.EditType;
import com.fptech.xml.XSDMapping.filepro.fpFormatException;
import java.text.ParseException;
import java.text.StringCharacterIterator;

public class fpNumber {
    StringBuffer decimalPortion = null;
    StringBuffer fractionalPortion = null;
    int sign = POSITIVE;
    boolean currencySymbol = false;
    int invalidCharAt = -1;
    static int POSITIVE = 0;
    static int NEGATIVE = 1;

    public void parse(String text) throws ParseException {
        char c;
        int toPos;
        int decpos = text.indexOf(46);
        int startpos = 0;
        int count = 0;
        StringCharacterIterator sci = new StringCharacterIterator(text);
        char c2 = sci.first();
        while (c2 != '\uffff') {
            if (Character.isDigit(c2) || c2 == '+') break;
            if (Character.isWhitespace(c2)) {
                ++count;
            } else if (c2 == '$') {
                this.currencySymbol = true;
                ++count;
            } else if (c2 == '-') {
                this.sign = NEGATIVE;
                ++count;
            } else {
                if (c2 == '.') break;
                this.invalidCharAt = count;
                break;
            }
            c2 = sci.next();
        }
        if (this.invalidCharAt != -1) {
            this.decimalPortion = null;
            this.fractionalPortion = null;
            throw new ParseException("Unparseable Number: \"" + text + "\"", this.invalidCharAt);
        }
        startpos = count;
        if (decpos == -1) {
            this.decimalPortion = new StringBuffer(text);
        } else {
            this.decimalPortion = new StringBuffer(text.substring(startpos, decpos));
            this.fractionalPortion = new StringBuffer(text.substring(decpos + 1));
        }
        if (this.decimalPortion != null) {
            String decStr = decpos == -1 ? new String(text.substring(startpos)) : new String(text.substring(startpos, decpos));
            StringCharacterIterator dsci = new StringCharacterIterator(decStr);
            toPos = 0;
            int dcount = 0;
            c = dsci.first();
            while (c != '\uffff') {
                if (Character.isDigit(c)) {
                    this.decimalPortion.setCharAt(toPos++, c);
                } else if (c != ',') {
                    this.decimalPortion = null;
                    this.invalidCharAt = startpos + dcount;
                    throw new ParseException("Unparseable Number: \"" + text + "\"", this.invalidCharAt);
                }
                ++dcount;
                c = dsci.next();
            }
        }
        if (this.fractionalPortion != null) {
            String fracStr = new String(text.substring(decpos + 1));
            StringCharacterIterator fsci = new StringCharacterIterator(fracStr);
            toPos = 0;
            int fcount = 0;
            c = fsci.first();
            while (c != '\uffff') {
                if (!Character.isDigit(c)) {
                    if (Character.isWhitespace(c)) break;
                    this.decimalPortion = null;
                    this.fractionalPortion = null;
                    this.invalidCharAt = decpos + 1 + fcount;
                    throw new ParseException("Unparseable Number: \"" + text + "\"", this.invalidCharAt);
                }
                this.fractionalPortion.setCharAt(toPos++, c);
                ++fcount;
                c = fsci.next();
            }
        }
    }

    public void parse(int value) throws ParseException {
        Integer wrapper = new Integer(value);
        this.parse(wrapper.toString());
    }

    public void parse(long value) throws ParseException {
        Long wrapper = new Long(value);
        this.parse(wrapper.toString());
    }

    public void parse(float value) throws ParseException {
        Float wrapper = new Float(value);
        this.parse(wrapper.toString());
    }

    public void parse(double value) throws ParseException {
        Double wrapper = new Double(value);
        this.parse(wrapper.toString());
    }

    public String format(EditType edtype, int outlen) throws ParseException, fpFormatException {
        char charToSet;
        int fractNeeded;
        StringBuffer sb = new StringBuffer(outlen);
        int numCommas = 0;
        int spaceRequired = 0;
        int declen = 0;
        int decimalPoint = 0;
        int i = 0;
        while (i < outlen) {
            sb.append(' ');
            ++i;
        }
        if (this.invalidCharAt != -1) {
            throw new ParseException("Can not format until parsing error is corrected", this.invalidCharAt);
        }
        declen = this.decimalPortion.length();
        if (edtype.isCommaType() && declen > 0) {
            numCommas = (declen - 1) / 3;
        }
        if ((fractNeeded = edtype.getFractDigits()) > 0) {
            decimalPoint = 1;
        }
        spaceRequired = declen + fractNeeded + numCommas + decimalPoint;
        if (this.currencySymbol) {
            ++spaceRequired;
        }
        if (this.sign == NEGATIVE) {
            ++spaceRequired;
        }
        if (spaceRequired > outlen) {
            throw new fpFormatException(spaceRequired);
        }
        int toLocation = outlen - 1;
        boolean roundUp = false;
        if (fractNeeded > 0 && toLocation >= 0) {
            char firstDropped;
            int fractlen = 0;
            if (this.fractionalPortion != null) {
                fractlen = this.fractionalPortion.length();
            }
            if (fractlen > fractNeeded && (firstDropped = this.fractionalPortion.charAt(fractNeeded)) == '9') {
                roundUp = true;
            }
            while (fractNeeded > fractlen) {
                sb.setCharAt(toLocation--, '0');
                --fractNeeded;
            }
            while (fractNeeded > 0) {
                charToSet = this.fractionalPortion.charAt(fractNeeded - 1);
                if (roundUp) {
                    if (charToSet == '9') {
                        charToSet = '0';
                    } else {
                        roundUp = false;
                        charToSet = (char)(charToSet + '\u0001');
                    }
                }
                sb.setCharAt(toLocation--, charToSet);
                --fractNeeded;
            }
            sb.setCharAt(toLocation--, '.');
        }
        int decCount = 0;
        while (declen > 0 && toLocation >= 0) {
            charToSet = this.decimalPortion.charAt(declen - 1);
            if (roundUp) {
                if (charToSet == '9') {
                    charToSet = '0';
                } else {
                    roundUp = false;
                    charToSet = (char)(charToSet + '\u0001');
                }
            }
            if (edtype.isCommaType() && decCount > 0 && decCount % 3 == 0) {
                sb.setCharAt(toLocation--, ',');
            }
            sb.setCharAt(toLocation, charToSet);
            --toLocation;
            --declen;
            ++decCount;
        }
        if (roundUp) {
            if (edtype.isCommaType() && decCount > 0 && decCount % 3 == 0) {
                if (toLocation < 1) {
                    throw new fpFormatException(spaceRequired + 1);
                }
                sb.setCharAt(toLocation--, ',');
            }
            if (toLocation < 0) {
                throw new fpFormatException(spaceRequired + 1);
            }
            sb.setCharAt(toLocation, '1');
            --toLocation;
        }
        if (this.sign == NEGATIVE) {
            if (toLocation < 0) {
                throw new fpFormatException(spaceRequired + 1);
            }
            sb.setCharAt(toLocation, '-');
            --toLocation;
        }
        if (this.currencySymbol) {
            if (toLocation < 0) {
                throw new fpFormatException(spaceRequired + 1);
            }
            sb.setCharAt(toLocation, '$');
            --toLocation;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            String text = args[0];
            fpNumber fp = new fpNumber();
            EditType ed1 = new EditType(37);
            EditType ed2 = new EditType(12);
            try {
                fp.parse(text);
                String str1 = fp.format(ed1, 20);
                String str2 = fp.format(ed2, 20);
                System.out.println("Input " + text + " Yields " + str1 + " : " + str2);
            }
            catch (ParseException e) {
                System.out.println("ParseException: " + e);
            }
            catch (fpFormatException f) {
                System.out.println("fpFormatException " + f);
            }
        }
    }
}

