/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class fpXLog {
    private static final long serialVersionUID = 1L;
    private PrintWriter logWriter;
    private int loglevel = 0;
    public static final int NO_LOGGING = 0;
    public static final int ERROR_LOGGING = 1;
    public static final int WARN_LOGGING = 2;
    public static final int INFORMATION_LOGGING = 3;
    public static final int DEBUG_LOGGING = 4;

    public void writeLog(int level, String s) {
        if (level > this.loglevel) {
            return;
        }
        if (this.logWriter != null) {
            Date d = new Date();
            switch (level) {
                case 1: {
                    this.logWriter.print("ERROR: ");
                    break;
                }
                case 2: {
                    this.logWriter.print("WARN:  ");
                    break;
                }
                case 3: {
                    this.logWriter.print("INFO:  ");
                    break;
                }
                case 4: {
                    this.logWriter.print("DEBUG: ");
                }
            }
            this.logWriter.print(String.valueOf(d.toString()) + " ");
            this.logWriter.println(s);
            this.logWriter.flush();
        } else {
            System.out.println(s);
        }
    }

    public void writeError(String s) {
        if (this.loglevel >= 1) {
            this.writeLog(1, s);
        }
    }

    public void writeWarning(String s) {
        if (this.loglevel >= 2) {
            this.writeLog(2, s);
        }
    }

    public void writeInfo(String s) {
        if (this.loglevel >= 3) {
            this.writeLog(3, s);
        }
    }

    public void writeDebug(String s) {
        if (this.loglevel >= 4) {
            this.writeLog(4, s);
        }
    }

    public void logException(Exception e) {
        StackTraceElement[] ste = e.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            this.writeLog(1, ste[i].toString());
            ++i;
        }
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    public fpXLog(String logName, boolean append, int logLevel) {
        this.loglevel = logLevel;
        try {
            this.logWriter = new PrintWriter(new FileOutputStream(logName, append));
        }
        catch (IOException e) {
            this.logWriter = null;
            System.out.println("Could not create log file " + logName);
        }
        if (this.logWriter != null) {
            this.writeLog(3, "log initialized.");
        }
    }
}

