/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.DocumentTracer;
import com.fptech.xml.XSDMapping.filepro.FormatType;
import com.fptech.xml.XSDMapping.filepro.PRCDialog;
import com.fptech.xml.XSDMapping.filepro.XSDfilter;
import com.fptech.xml.XSDMapping.filepro.fpConfig;
import com.fptech.xml.XSDMapping.filepro.fpElement;
import com.fptech.xml.XSDMapping.filepro.fpField;
import com.fptech.xml.XSDMapping.filepro.fpFile;
import com.fptech.xml.XSDMapping.filepro.fpFormatFilter;
import com.fptech.xml.XSDMapping.filepro.fpHelp;
import com.fptech.xml.XSDMapping.filepro.fpLogViewer;
import com.fptech.xml.XSDMapping.filepro.fpLookupDialog;
import com.fptech.xml.XSDMapping.filepro.fpMaxLengthField;
import com.fptech.xml.XSDMapping.filepro.fpNamedType;
import com.fptech.xml.XSDMapping.filepro.fpRestriction;
import com.fptech.xml.XSDMapping.filepro.fpSelectRootDialog;
import com.fptech.xml.XSDMapping.filepro.fpStatusBar;
import com.fptech.xml.XSDMapping.filepro.fpTableModel;
import com.fptech.xml.XSDMapping.filepro.fpTypeFinder;
import com.fptech.xml.XSDMapping.filepro.fpX;
import com.fptech.xml.XSDMapping.filepro.fpXLog;
import com.fptech.xml.XSDMapping.filepro.fpXMapSaveDialog;
import com.fptech.xml.XSDMapping.filepro.fpXMapTableModel;
import com.fptech.xml.XSDMapping.filepro.fpxReader;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class fpXMap {
    String version = "0.91";
    JMenuBar menubar;
    JMenu fileMenu;
    JMenuItem newItem;
    JMenuItem openItem;
    JMenuItem saveItem;
    JMenuItem saveAsItem;
    JMenuItem exitItem;
    JMenu fileproMenu;
    JMenu viewMenu;
    JMenuItem mainFileItem;
    JMenuItem lookupFileItem;
    JMenuItem prcItem;
    JMenu xsdMenu;
    JMenuItem xsdItem;
    JMenuItem xsdViewItem;
    JMenu helpMenu;
    JMenuItem helpItem;
    JMenuItem taskhelpItem;
    JMenuItem menuhelpItem;
    JMenuItem logViewItem;
    JMenuItem versionItem;
    static final String helpNavFile = "navigation.list";
    JButton loopStartButton;
    JButton loopControlButton;
    JButton insertRowBeforeButton;
    JButton insertRowAfterButton;
    JButton deleteRowButton;
    JFrame xmapFrame;
    JFrame sFrame;
    JSplitPane displayPanel;
    JInternalFrame fileProPanel;
    JInternalFrame xsdPanel;
    fpStatusBar status;
    fpXLog log = null;
    fpConfig config = null;
    String logName = "/fpxsd.log";
    String mainFilename = null;
    String autoPrcName = null;
    String outputPrcName = null;
    String xsdName = null;
    static String xsdPath = null;
    String fpxName = null;
    String fpxPath = null;
    String loopLabel = null;
    String schemaNamespace = null;
    LinkedList<fpElement> tagList;
    ArrayList<fpElement> tagArray;
    private String[] colNames = new String[]{"Expand", "Tag path", "XML Tag", "Tag type", "Data type", "filePro field", "minOccurs", "maxOccurs", "Restrictions"};
    JTable xmapTable;
    fpXMapTableModel xmapModel;
    private String[] fpColNames = new String[]{"Number", "Heading", "Length", "Type"};
    JTable fpTable;
    fpTableModel fpModel;
    fpStatusBar fpStatus;
    fpFile mainFile;
    LinkedList<fpElement> parsedTags = null;
    LinkedList<fpNamedType> parsedTypes = null;
    LinkedList<String> parsedTopLevelElements = null;
    ArrayList<fpTypeFinder> typeList = null;
    static Properties xmapProp = null;
    String propFileName = null;
    String loadFilename = null;
    static int lastTableSelected = -1;
    static int FILEPRO_TABLE = 0;
    static int MAPPING_TABLE = 1;
    static int EXPAND_COLUMN = 0;
    static int PATH_COLUMN = 1;
    static int NAME_COLUMN = 2;
    static int TAGTYPE_COLUMN = 3;
    static int DATATYPE_COLUMN = 4;
    static int FILEPRO_COLUMN = 5;
    static int MIN_COLUMN = 6;
    static int MAX_COLUMN = 7;
    static int RESTRICT_COLUMN = 8;
    static int BEFORE = 0;
    static int AFTER = 1;
    int nCols = 5;
    int defaultRows = 50;
    boolean shrinkRefused = false;
    boolean shrinkFlagReset = false;
    boolean tableChanged = false;

    public static void setLastTableSelected(int tableNumber) {
        lastTableSelected = tableNumber;
    }

    public static int getLastTableSelected() {
        return lastTableSelected;
    }

    private void setupLogging() {
        Boolean append = false;
        String ldir = fpConfig.getTmpDirectory();
        if (ldir == null) {
            ldir = "/tmp";
        }
        this.logName = String.valueOf(ldir) + this.logName;
        this.log = new fpXLog(this.logName, append, 4);
    }

    private void resetLog() {
        if (this.log != null) {
            this.log.close();
        }
        this.setupLogging();
    }

    public static void showError(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 0);
    }

    public static void showMessage(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 1);
    }

    public boolean cleanup() {
        FileWriter fw = null;
        if (!this.looseUnsavedChanges()) {
            return false;
        }
        if (xmapProp != null) {
            try {
                Rectangle r = this.xmapFrame.getBounds();
                int xpos = r.x;
                int ypos = r.y;
                int width = r.width;
                int height = r.height;
                xmapProp.setProperty("xpos", "" + xpos);
                xmapProp.setProperty("ypos", "" + ypos);
                xmapProp.setProperty("width", "" + width);
                xmapProp.setProperty("height", "" + height);
                this.saveColumnWidths();
                fw = new FileWriter(this.propFileName);
                xmapProp.store(fw, "Properties file for fpXMap application.");
            }
            catch (IOException e) {
                fpXMap.showError("Error", "IO error writing properties file " + this.propFileName + "\n" + e.toString());
            }
            if (this.log != null) {
                this.log.close();
            }
        }
        return true;
    }

    private void displayMainFileProFile(String fname) {
        if (fname != null) {
            this.fpModel.setDataVector(this.fileToObjectArray(fname, true), this.fpColNames);
            if (this.mainFile != null) {
                this.fpStatus.setWest("filePro file: " + fname);
                this.fpStatus.setEast("Record length: " + this.mainFile.getKeyLength());
            }
            this.prcItem.setEnabled(true);
            this.lookupFileItem.setEnabled(true);
            this.mainFilename = fname;
            this.fpModel.fireTableDataChanged();
        }
    }

    private void setMainFileProFile() {
        String dataDir = this.config.getDataDirectory();
        JFileChooser fps = new JFileChooser(dataDir);
        fps.setFileSelectionMode(1);
        int result = fps.showOpenDialog(null);
        String selName = null;
        if (result == 0) {
            File selFile = fps.getSelectedFile();
            this.config.setDataDirectory(selFile.getParent());
            selName = selFile.getName();
            if (this.log != null) {
                this.log.writeDebug("Main file selected - " + selName);
            }
            this.displayMainFileProFile(selName);
            this.mainFilename = selName;
            this.openItem.setEnabled(true);
            this.saveItem.setEnabled(true);
            this.saveAsItem.setEnabled(true);
        }
    }

    private void showLookupFile() {
        String dataDir = this.config.getDataDirectory();
        JFileChooser fps = new JFileChooser(dataDir);
        fps.setFileSelectionMode(1);
        int result = fps.showOpenDialog(null);
        if (result == 0) {
            File selFile = fps.getSelectedFile();
            this.config.setDataDirectory(selFile.getParent());
            String selName = selFile.getName();
            if (this.log != null) {
                this.log.writeDebug("Lookup file selected - " + selName);
            }
            fpLookupDialog fpld = new fpLookupDialog(selName, dataDir, this.log);
            fpld.init();
        }
    }

    public static File selectXSDFile(Component parent) {
        File selFile = null;
        xsdPath = xmapProp.getProperty("xsdDirectory");
        JFileChooser fc = xsdPath != null ? new JFileChooser(xsdPath) : new JFileChooser();
        fc.setFileFilter(new XSDfilter());
        int returnVal = fc.showDialog(parent, "Select");
        if (returnVal == 0) {
            selFile = fc.getSelectedFile();
        }
        if (selFile != null) {
            String fullPath;
            try {
                fullPath = selFile.getCanonicalPath();
            }
            catch (IOException e) {
                fullPath = selFile.getAbsolutePath();
            }
            int nameLocation = fullPath.lastIndexOf(selFile.getName());
            if (nameLocation != -1) {
                xsdPath = fullPath.substring(0, nameLocation);
                xmapProp.setProperty("xsdDirectory", xsdPath);
            }
        }
        return selFile;
    }

    private void setLoopLabel(String s) {
        this.loopLabel = s;
        if (this.log != null) {
            this.log.writeDebug("loop label set to " + s);
        }
    }

    private String getLoopLabel() {
        return this.loopLabel;
    }

    private String getLoopLabel(String title) {
        String s = null;
        JLabel l = new JLabel("Label");
        final fpMaxLengthField tf = new fpMaxLengthField(7, 7);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        final JDialog ld = new JDialog((Frame)this.xmapFrame, true);
        JPanel textPane = new JPanel();
        JPanel buttonPane = new JPanel();
        this.setLoopLabel(null);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.setLoopLabel(tf.getText());
                ld.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.setLoopLabel(null);
                ld.dispose();
            }
        });
        textPane.add(l);
        textPane.add(tf);
        textPane.setVisible(true);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.setMaximumSize(buttonPane.getPreferredSize());
        buttonPane.setVisible(true);
        ld.setModal(true);
        ld.setTitle(title);
        ld.add((Component)textPane, "Center");
        ld.add((Component)buttonPane, "South");
        ld.setBounds(80, 100, 300, 100);
        ld.setResizable(false);
        ld.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                fpXMap.this.setLoopLabel(null);
                ld.dispose();
            }
        });
        ld.setVisible(true);
        s = this.getLoopLabel();
        if (this.log != null) {
            this.log.writeDebug("Label Dialog returning " + s);
        }
        return s;
    }

    private void showProcessingTable() {
        String fpDir = this.config.getDataDirectory();
        String startDir = String.valueOf(fpDir) + this.mainFilename;
        JFileChooser fps = new JFileChooser(startDir);
        fps.setFileFilter(new fpFormatFilter(2));
        fps.setFileSelectionMode(0);
        int result = fps.showOpenDialog(null);
        if (result == 0) {
            File selFile = fps.getSelectedFile();
            String prcname = selFile.getAbsolutePath();
            PRCDialog prcd = new PRCDialog(prcname, this.log);
            prcd.init();
        }
    }

    private void loopStart() {
        String lab = null;
        if (fpXMap.getLastTableSelected() == FILEPRO_TABLE) {
            return;
        }
        int crow = this.xmapTable.getSelectedRow();
        if (crow == -1) {
            fpXMap.showError("Loop Start", "Row must be selected as the insertion point.\nLabel will be inserted above the selected row.");
            return;
        }
        Object[] oa = new Object[this.colNames.length];
        lab = this.getLoopLabel("Loop Start Label");
        if (lab == null) {
            return;
        }
        int i = 1;
        while (i < this.colNames.length) {
            oa[i] = "";
            ++i;
        }
        oa[fpXMap.EXPAND_COLUMN] = false;
        oa[fpXMap.NAME_COLUMN] = lab;
        oa[fpXMap.TAGTYPE_COLUMN] = "S";
        this.xmapModel.insertRow(crow, oa);
    }

    private void loopEnd() {
        String lab = null;
        int crow = this.xmapTable.getSelectedRow();
        if (fpXMap.getLastTableSelected() == FILEPRO_TABLE) {
            return;
        }
        if (crow == -1) {
            fpXMap.showError("Loop End", "Row must be selected as the insertion point. \nLabel will be inserted below the selected row.");
            return;
        }
        Object[] oa = new Object[this.colNames.length];
        lab = this.getLoopLabel("Loop Control Label");
        if (lab == null) {
            return;
        }
        int i = 1;
        while (i < this.colNames.length) {
            oa[i] = "";
            ++i;
        }
        oa[fpXMap.EXPAND_COLUMN] = false;
        oa[fpXMap.NAME_COLUMN] = lab;
        oa[fpXMap.TAGTYPE_COLUMN] = "C";
        this.xmapModel.insertRow(crow + 1, oa);
    }

    private void insertRow(int where) {
        int crow = this.xmapTable.getSelectedRow();
        if (fpXMap.getLastTableSelected() == FILEPRO_TABLE) {
            return;
        }
        if (crow == -1) {
            fpXMap.showError("Insert Row", "Row must be selected as the insertion point.");
            return;
        }
        Object[] oa = new Object[this.colNames.length];
        int i = 0;
        while (i < this.colNames.length) {
            oa[i] = i == EXPAND_COLUMN ? Boolean.valueOf(false) : "";
            ++i;
        }
        if (where == BEFORE) {
            this.xmapModel.insertRow(crow, oa);
        } else {
            this.xmapModel.insertRow(crow + 1, oa);
        }
    }

    private void deleteRow() {
        int crow = this.xmapTable.getSelectedRow();
        if (fpXMap.getLastTableSelected() == FILEPRO_TABLE) {
            return;
        }
        if (crow == -1) {
            fpXMap.showError("Delete Row", "Row to be deleted must first be selected.");
            return;
        }
        this.xmapModel.removeRow(crow);
    }

    private JPanel buildButtonBar() {
        JPanel p = new JPanel();
        this.loopStartButton = new JButton("Loop Start");
        this.loopControlButton = new JButton("Loop End");
        this.insertRowBeforeButton = new JButton("Insert Above");
        this.insertRowAfterButton = new JButton("Insert Below");
        this.deleteRowButton = new JButton("Delete Row");
        this.loopStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.loopStart();
            }
        });
        this.loopControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.loopEnd();
            }
        });
        this.insertRowBeforeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.insertRow(BEFORE);
            }
        });
        this.insertRowAfterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.insertRow(AFTER);
            }
        });
        this.deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMap.this.deleteRow();
            }
        });
        p.add(this.loopStartButton);
        p.add(this.loopControlButton);
        p.add(this.insertRowBeforeButton);
        p.add(this.insertRowAfterButton);
        p.add(this.deleteRowButton);
        p.setMaximumSize(p.getPreferredSize());
        p.setVisible(true);
        return p;
    }

    private int getTokenCount(String rootElement) {
        int count = 0;
        for (fpElement te : this.tagList) {
            if (!te.getName().equals(rootElement) && !te.getPath().startsWith("/" + rootElement)) continue;
            ++count;
            if (te.attributes == null) continue;
            count += te.attributes.size();
        }
        return count;
    }

    private Object[][] tagListToObjectArray() {
        Object[][] objArray = null;
        String rootElement = null;
        rootElement = this.getRootElement();
        if (this.tagList == null || this.tagList.isEmpty() || rootElement == null) {
            return this.buildEmptyObjectArray(50, this.colNames.length);
        }
        int rows = this.getTokenCount(rootElement);
        int cols = this.colNames.length;
        int r = 0;
        if (this.log != null) {
            this.log.writeDebug("Taglist");
        }
        objArray = new Object[rows][cols];
        for (fpElement te : this.tagList) {
            if (te.getPath().contains("/") && te.getName() != null) {
                int lastSlashPos = te.getPath().lastIndexOf(47);
                if (this.log != null) {
                    this.log.writeDebug("Path before split is " + te.getPath());
                    this.log.writeDebug("Position of last slash is " + lastSlashPos);
                }
                String path = te.getPath().substring(0, lastSlashPos);
                String name = te.getPath().substring(lastSlashPos + 1);
                te.setPath(path);
                te.setName(name);
                if (this.log != null) {
                    this.log.writeDebug("Path: " + path + "  Name: " + name);
                    this.log.writeDebug("Path after setPath() is " + te.getPath());
                    this.log.writeDebug("Name after setName() is " + te.getName());
                }
            }
            if (this.log != null) {
                this.log.writeDebug("Tag: " + te.getName() + " TagType: " + te.getTagType());
            }
            if (!te.getName().equals(rootElement) && !te.getPath().startsWith("/" + rootElement)) continue;
            int c = 0;
            while (c < cols) {
                switch (c) {
                    case 0: {
                        objArray[r][c] = te.getExpand();
                        break;
                    }
                    case 1: {
                        if (te.getPath() != null) {
                            objArray[r][c] = te.getPath();
                            break;
                        }
                        objArray[r][c] = "";
                        break;
                    }
                    case 2: {
                        if (te.getName() != null) {
                            objArray[r][c] = te.getName();
                            break;
                        }
                        objArray[r][c] = "";
                        break;
                    }
                    case 3: {
                        if (te.getTagType() != null) {
                            objArray[r][c] = te.getTagType();
                            break;
                        }
                        objArray[r][c] = "E";
                        break;
                    }
                    case 4: {
                        if (te.getType() != null) {
                            objArray[r][c] = te.getType();
                            break;
                        }
                        objArray[r][c] = "";
                        break;
                    }
                    case 5: {
                        if (te.getMappedField() != null) {
                            objArray[r][c] = te.getMappedField();
                            break;
                        }
                        objArray[r][c] = "";
                        break;
                    }
                    case 6: {
                        if (te.getMinOccurs() != null) {
                            objArray[r][c] = te.getMinOccurs();
                            break;
                        }
                        objArray[r][c] = "0";
                        break;
                    }
                    case 7: {
                        if (te.getMaxOccurs() != null) {
                            objArray[r][c] = te.getMaxOccurs();
                            break;
                        }
                        objArray[r][c] = "1";
                        break;
                    }
                    case 8: {
                        if (te.getRestrictions() == null) {
                            objArray[r][c] = "";
                            break;
                        }
                        if (te.restrictions.size() == 0) {
                            objArray[r][c] = "";
                            break;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (fpRestriction tr : te.restrictions) {
                            sb.append(String.valueOf(tr.getType()) + " = " + tr.getValue() + " ");
                        }
                        objArray[r][c] = sb.toString();
                        break;
                    }
                    default: {
                        objArray[r][c] = "";
                    }
                }
                ++c;
            }
            ++r;
        }
        return objArray;
    }

    private Object[][] fileToObjectArray(String filename, boolean isMain) {
        Object[][] objArray = null;
        String dataDir = this.config.getDataDirectory();
        int numCols = this.fpColNames.length;
        fpFile fpf = new fpFile(dataDir, filename);
        int numFields = fpf.getNumberOfFields();
        if (isMain) {
            this.mainFile = fpf;
        }
        objArray = new Object[numFields][numCols];
        int i = 0;
        while (i < numFields) {
            fpField currField = fpf.getField(i + 1);
            if (currField != null) {
                objArray[i][0] = i + 1;
                objArray[i][1] = currField.getFieldName();
                objArray[i][2] = currField.getFieldLength();
                objArray[i][3] = currField.getFieldType();
            }
            ++i;
        }
        return objArray;
    }

    private Object[][] buildEmptyObjectArray(int rows, int cols) {
        Object[][] objArray = null;
        objArray = new Object[rows][cols];
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                objArray[r][c] = "";
                ++c;
            }
            ++r;
        }
        return objArray;
    }

    private void initFPTable() {
        Object[][] oa = this.mainFilename == null ? this.buildEmptyObjectArray(this.defaultRows, this.fpColNames.length) : this.fileToObjectArray(this.mainFilename, true);
        this.fpModel = new fpTableModel(oa, this.fpColNames);
        this.fpTable = new JTable(this.fpModel);
        JScrollPane scrollPane = new JScrollPane(this.fpTable);
        this.fpTable.setFillsViewportHeight(true);
        this.fpStatus = new fpStatusBar();
        Box box = Box.createVerticalBox();
        if (this.mainFile != null && this.mainFilename != null) {
            this.fpStatus.setWest(this.mainFilename);
            this.fpStatus.setEast("Record length: " + this.mainFile.getKeyLength());
        }
        box.add(scrollPane);
        box.add(this.fpStatus);
        this.fileProPanel.add(box);
    }

    private void setUpCheckBoxColumn(TableColumn column) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object col1Value = table.getValueAt(row, TAGTYPE_COLUMN);
                if (col1Value == null || !col1Value.toString().equalsIgnoreCase("T")) {
                    JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    comp.setText(null);
                    return comp;
                }
                return table.getDefaultRenderer(table.getColumnClass(column)).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        };
        column.setCellRenderer(renderer);
    }

    private fpNamedType findTypeByName(String name) {
        fpNamedType t = null;
        for (fpNamedType nt : this.parsedTypes) {
            if (this.log != null) {
                this.log.writeDebug("Comparing " + name + " to " + nt.getName());
            }
            if (!nt.getName().equals(name)) continue;
            if (this.log != null) {
                this.log.writeDebug("Found match!");
            }
            return nt;
        }
        return t;
    }

    private String getRootElement() {
        int size = this.parsedTopLevelElements.size();
        if (size == 0) {
            fpXMap.showError("Parse Error", "No root level element detected. Check log for details.");
            return null;
        }
        if (size == 1) {
            return this.parsedTopLevelElements.getFirst();
        }
        fpSelectRootDialog srd = new fpSelectRootDialog((Frame)this.xmapFrame, this.parsedTopLevelElements);
        srd.init();
        if (srd.getExitValue()) {
            return srd.getSelected();
        }
        return this.parsedTopLevelElements.getFirst();
    }

    void showNamedType(fpNamedType t) {
        int na = t.getAttributes() == null ? 0 : t.getAttributes().size();
        int nr = t.getRestrictions() == null ? 0 : t.getRestrictions().size();
        int nc = t.getChildren() == null ? 0 : t.getChildren().size();
        fpXMap.showMessage("Show Named Type", "Type: " + t.getType() + "\nBaseType: " + t.getBaseType() + "\n#Attributes: " + na + "\n#Restrictions: " + nr + "\n#Children: " + nc);
    }

    private void insertRowFromElement(int row, fpElement el, String path) {
        Object[] oa = new Object[this.colNames.length];
        oa[fpXMap.PATH_COLUMN] = path != null ? path : "";
        oa[fpXMap.NAME_COLUMN] = el.getName() != null ? el.getName() : "";
        oa[fpXMap.TAGTYPE_COLUMN] = el.getTagType() != null ? el.getTagType() : "E";
        oa[fpXMap.DATATYPE_COLUMN] = el.getType() != null ? el.getType() : "";
        oa[fpXMap.EXPAND_COLUMN] = el.getExpand();
        oa[fpXMap.FILEPRO_COLUMN] = el.getMappedField() != null ? el.getMappedField() : "";
        oa[fpXMap.MIN_COLUMN] = el.getMinOccurs() != null ? el.getMinOccurs() : "0";
        oa[fpXMap.MAX_COLUMN] = el.getMaxOccurs() != null ? el.getMaxOccurs() : "1";
        if (el.getRestrictions() == null) {
            oa[fpXMap.RESTRICT_COLUMN] = "";
        } else if (el.restrictions.size() == 0) {
            oa[fpXMap.RESTRICT_COLUMN] = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (fpRestriction tr : el.restrictions) {
                sb.append(String.valueOf(tr.getType()) + " = " + tr.getValue() + " ");
            }
            oa[fpXMap.RESTRICT_COLUMN] = sb.toString();
        }
        this.xmapModel.insertRow(row, oa);
    }

    private void addTypeToList(String path, String name, String oldType, String newType) {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        this.typeList.add(new fpTypeFinder(path, name, oldType, newType));
    }

    private String findOldType(String path, String name, String newType) {
        if (this.typeList == null) {
            return newType;
        }
        for (fpTypeFinder tf : this.typeList) {
            if (!tf.match(path, name, newType)) continue;
            return tf.getOldType();
        }
        return newType;
    }

    boolean isBaseType(String type) {
        return type.startsWith(String.valueOf(this.schemaNamespace) + ":");
    }

    fpElement findElementByName(String name) {
        for (fpElement e : this.tagList) {
            if (!(e.getPath() == null || e.getPath().isEmpty() ? e.getName().equals(name) : e.getPath().equals(name))) continue;
            return e;
        }
        return null;
    }

    private void expandRow(int row) {
        block8: {
            fpNamedType ty;
            String typeName;
            String parentName;
            String parentPath;
            block7: {
                parentPath = (String)this.xmapModel.getValueAt(row, PATH_COLUMN);
                parentName = (String)this.xmapModel.getValueAt(row, NAME_COLUMN);
                typeName = (String)this.xmapModel.getValueAt(row, DATATYPE_COLUMN);
                if (this.isBaseType(typeName)) {
                    if (this.log != null) {
                        this.log.writeDebug("Attempt to expand base type " + typeName);
                    }
                    return;
                }
                if (this.log != null) {
                    this.log.writeDebug("Searching for defined type " + typeName);
                }
                if ((ty = this.findTypeByName(typeName)) != null) break block7;
                if (this.log == null) break block8;
                this.log.writeDebug("Could not find defined type " + typeName + ". Checking defined elements.");
                fpElement el = this.findElementByName(typeName);
                if (el != null) break block8;
                this.log.writeDebug("Could not find " + typeName + " in defined elements.");
                break block8;
            }
            if (this.log != null) {
                this.log.writeDebug("Found Named Type " + typeName);
                this.log.writeDebug("Type of " + typeName + " is " + ty.getBaseType());
            }
            if (ty.getBaseType() != null) {
                this.xmapModel.setValueAt(ty.getBaseType(), row, DATATYPE_COLUMN);
                this.xmapModel.setValueAt("E", row, TAGTYPE_COLUMN);
                this.addTypeToList(parentPath, parentName, typeName, ty.getBaseType());
            }
            if (ty.hasChildren()) {
                int newRow = row + 1;
                String path = parentPath == null || parentPath.equals("") ? parentName : String.valueOf(parentPath) + "/" + parentName;
                for (fpElement chEl : ty.getChildren()) {
                    this.insertRowFromElement(newRow, chEl, path);
                    ++newRow;
                }
            }
        }
    }

    boolean isDescendent(String childPath, String testPath) {
        return childPath.contains(testPath);
    }

    private boolean isShrinkable(int row, String parentPath) {
        boolean retval = true;
        int childRow = row + 1;
        String childPath = (String)this.xmapModel.getValueAt(childRow, PATH_COLUMN);
        while (childRow < this.xmapTable.getRowCount() && this.isDescendent(childPath, parentPath)) {
            String mappedField = (String)this.xmapModel.getValueAt(childRow, FILEPRO_COLUMN);
            if (mappedField != null && !mappedField.isEmpty()) {
                retval = false;
                break;
            }
            if (++childRow >= this.xmapTable.getRowCount()) continue;
            childPath = (String)this.xmapModel.getValueAt(childRow, PATH_COLUMN);
        }
        return retval;
    }

    private boolean shrinkRow(int row) {
        String parentPath = (String)this.xmapModel.getValueAt(row, PATH_COLUMN);
        String parentName = (String)this.xmapModel.getValueAt(row, NAME_COLUMN);
        String typeName = (String)this.xmapModel.getValueAt(row, DATATYPE_COLUMN);
        boolean wasShrunk = true;
        String testPath = parentPath == null || parentPath.equals("") ? parentName : String.valueOf(parentPath) + "/" + parentName;
        boolean rowMapped = true;
        String mappedField = (String)this.xmapModel.getValueAt(row, FILEPRO_COLUMN);
        if (mappedField == null || mappedField.isEmpty()) {
            rowMapped = false;
        }
        if (this.isShrinkable(row, testPath) && !rowMapped) {
            int childRow = row + 1;
            String childPath = (String)this.xmapModel.getValueAt(childRow, PATH_COLUMN);
            while (childRow < this.xmapTable.getRowCount() && this.isDescendent(childPath, testPath)) {
                this.xmapModel.removeRow(childRow);
                if (childRow >= this.xmapTable.getRowCount()) continue;
                childPath = (String)this.xmapModel.getValueAt(childRow, PATH_COLUMN);
            }
            String oldDataType = this.findOldType(parentPath, parentName, typeName);
            this.xmapModel.setValueAt(oldDataType, row, DATATYPE_COLUMN);
            if (!this.isBaseType(oldDataType)) {
                this.xmapModel.setValueAt("T", row, TAGTYPE_COLUMN);
            }
            wasShrunk = true;
        } else {
            fpXMap.showError("Contract Row", "Can not reverse expansion of a defined type \nif it or a child element is mapped to a filePro field.");
            wasShrunk = false;
        }
        return wasShrunk;
    }

    private void setPreferredColumnWidths() {
        if (xmapProp == null) {
            return;
        }
        String value = xmapProp.getProperty("expandWidth");
        if (value != null) {
            this.xmapTable.getColumnModel().getColumn(EXPAND_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("pathWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(PATH_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("tagWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(NAME_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("tagtypeWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(TAGTYPE_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if (value != null) {
            this.xmapTable.getColumnModel().getColumn(DATATYPE_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("fileProWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(FILEPRO_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("mincolWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(MIN_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("maxcolWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(MAX_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
        if ((value = xmapProp.getProperty("restrictWidth")) != null) {
            this.xmapTable.getColumnModel().getColumn(RESTRICT_COLUMN).setPreferredWidth(Integer.parseInt(value));
        }
    }

    private void saveColumnWidths() {
        if (xmapProp == null) {
            return;
        }
        xmapProp.setProperty("expandWidth", "" + this.xmapTable.getColumnModel().getColumn(EXPAND_COLUMN).getWidth());
        xmapProp.setProperty("pathWidth", "" + this.xmapTable.getColumnModel().getColumn(PATH_COLUMN).getWidth());
        xmapProp.setProperty("tagWidth", "" + this.xmapTable.getColumnModel().getColumn(NAME_COLUMN).getWidth());
        xmapProp.setProperty("tagtypeWidth", "" + this.xmapTable.getColumnModel().getColumn(TAGTYPE_COLUMN).getWidth());
        xmapProp.setProperty("datatypeWidth", "" + this.xmapTable.getColumnModel().getColumn(DATATYPE_COLUMN).getWidth());
        xmapProp.setProperty("fileProWidth", "" + this.xmapTable.getColumnModel().getColumn(FILEPRO_COLUMN).getWidth());
        xmapProp.setProperty("mincolWidth", "" + this.xmapTable.getColumnModel().getColumn(MIN_COLUMN).getWidth());
        xmapProp.setProperty("maxcolWidth", "" + this.xmapTable.getColumnModel().getColumn(MAX_COLUMN).getWidth());
        xmapProp.setProperty("restrictWidth", "" + this.xmapTable.getColumnModel().getColumn(RESTRICT_COLUMN).getWidth());
    }

    private void initTable() {
        Object[][] oa = this.tagList == null ? this.buildEmptyObjectArray(50, this.colNames.length) : this.tagListToObjectArray();
        int i = 0;
        while (i < 50) {
            oa[i][fpXMap.EXPAND_COLUMN] = false;
            ++i;
        }
        this.xmapModel = new fpXMapTableModel(oa, this.colNames);
        this.xmapTable = new JTable(this.xmapModel);
        this.setPreferredColumnWidths();
        JScrollPane scrollPane = new JScrollPane(this.xmapTable);
        this.xmapTable.setFillsViewportHeight(true);
        this.setUpCheckBoxColumn(this.xmapTable.getColumnModel().getColumn(EXPAND_COLUMN));
        this.xmapModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int col = e.getColumn();
                if (fpXMap.this.shrinkRefused) {
                    fpXMap.this.shrinkRefused = false;
                    fpXMap.this.shrinkFlagReset = true;
                    return;
                }
                if (col == EXPAND_COLUMN) {
                    boolean wasDefinedType;
                    if (fpXMap.this.shrinkFlagReset) {
                        fpXMap.this.shrinkFlagReset = false;
                        return;
                    }
                    boolean newValue = (Boolean)fpXMap.this.xmapModel.getValueAt(row, col);
                    String dataType = fpXMap.this.xmapModel.getValueAt(row, DATATYPE_COLUMN).toString();
                    String tagType = fpXMap.this.xmapModel.getValueAt(row, TAGTYPE_COLUMN).toString();
                    String path = fpXMap.this.xmapModel.getValueAt(row, PATH_COLUMN).toString();
                    String name = fpXMap.this.xmapModel.getValueAt(row, NAME_COLUMN).toString();
                    boolean isDefinedType = tagType.equalsIgnoreCase("T");
                    String oldDataType = fpXMap.this.findOldType(path, name, dataType);
                    boolean bl = wasDefinedType = !fpXMap.this.isBaseType(oldDataType);
                    if (isDefinedType || wasDefinedType) {
                        if (newValue) {
                            fpXMap.this.expandRow(row);
                        } else if (!fpXMap.this.shrinkRow(row)) {
                            fpXMap.this.shrinkRefused = true;
                            fpXMap.this.xmapModel.setValueAt(true, row, EXPAND_COLUMN);
                            fpXMap.this.xmapModel.fireTableCellUpdated(row, EXPAND_COLUMN);
                        }
                    }
                }
                fpXMap.this.tableChanged = true;
            }
        });
        Box box = Box.createVerticalBox();
        box.add(scrollPane);
        box.add(this.buildButtonBar());
        this.xsdPanel.add((Component)box, "Center");
    }

    private void emptyFPTable() {
        Object[][] oa = this.buildEmptyObjectArray(this.defaultRows, this.fpColNames.length);
        if (this.fpModel == null) {
            this.fpModel = new fpTableModel(oa, this.fpColNames);
        } else {
            this.fpModel.setDataVector(oa, this.fpColNames);
        }
        this.fpModel.fireTableDataChanged();
    }

    private void emptyTable() {
        Object[][] oa = this.buildEmptyObjectArray(50, this.colNames.length);
        int i = 0;
        while (i < 50) {
            oa[i][fpXMap.EXPAND_COLUMN] = false;
            ++i;
        }
        if (this.xmapModel == null) {
            this.xmapModel = new fpXMapTableModel(oa, this.colNames);
        } else {
            this.xmapModel.setDataVector(oa, this.colNames);
        }
        this.setPreferredColumnWidths();
        this.xmapModel.fireTableDataChanged();
        this.status.setEast("XSD file: ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getAndParseXSDFile(String fullName, boolean loadTable) {
        if (fullName == null) {
            File selected = fpXMap.selectXSDFile(this.xmapFrame);
            if (selected == null) return;
            try {
                this.xsdName = selected.getCanonicalPath();
            }
            catch (IOException e) {
                this.xsdName = selected.getAbsolutePath();
            }
            this.status.setEast("XSD file: " + selected.getName());
        } else {
            String name = null;
            File f = new File(fullName);
            if (!f.exists()) {
                if (loadTable) return;
                fpXMap.showMessage("Load XSD", "XSD file " + fullName + " specified in mapping file can not be found.\n" + "Editing in the mapping table is limited to existing tags.\n" + "Unexpanded tags can not be expanded.");
                return;
            }
            if (!f.canRead()) {
                if (loadTable) return;
                fpXMap.showMessage("LOAD XSD", "XSD file " + fullName + " specified in mapping file can not be read.\n" + "Editing in the mapping table is limited to existing tags.\n" + "Unexpanded tags can not be expanded.");
                return;
            }
            name = f.getName();
            this.status.setEast("XSD file: " + name);
            this.xsdName = fullName;
        }
        DocumentTracer dt = new DocumentTracer();
        dt.setLog(this.log);
        this.tagList = dt.parseXSD(this.xsdName);
        if (this.tagList == null) {
            fpXMap.showError("XSD Parsing error", "Check log for details.");
            return;
        } else {
            this.parsedTags = dt.getTagList();
            this.parsedTypes = dt.getTypeList();
            this.parsedTopLevelElements = dt.getTopLevelNames();
            this.schemaNamespace = dt.getSchemaNamespace();
            if (loadTable) {
                this.xmapModel.setDataVector(this.tagListToObjectArray(), this.colNames);
                this.setPreferredColumnWidths();
            }
            this.tableChanged = false;
            this.xmapModel.setXSDName(this.xsdName);
        }
    }

    private boolean looseUnsavedChanges() {
        boolean retval = true;
        if (this.tableChanged) {
            int choice = JOptionPane.showConfirmDialog(null, "You have unsaved changes which will be lost if you continue with this operation. \nDo you wish to continue?", "Unsaved Changes Warning", 0);
            if (choice != 0) {
                retval = false;
            }
        } else {
            retval = true;
        }
        return retval;
    }

    private boolean removeCurrentMapping() {
        if (!this.looseUnsavedChanges()) {
            return false;
        }
        this.parsedTags = null;
        this.parsedTypes = null;
        this.parsedTopLevelElements = null;
        this.typeList = null;
        this.tagList = null;
        this.loadFilename = null;
        this.mainFilename = null;
        this.xsdName = null;
        this.xmapModel.setXSDName(this.xsdName);
        this.status.setWest("");
        this.fpxName = null;
        this.fpStatus.setWest("filePro file: ");
        this.fpStatus.setEast("Record length: ");
        this.emptyTable();
        this.emptyFPTable();
        this.tableChanged = false;
        return true;
    }

    private void showVersion() {
        JOptionPane.showMessageDialog(null, "fpXMap Version: " + this.version + "\nCopyright 2010 by fP Technologies, Inc." + "\nThis application makes use of the Apache Xerces2 Parser for Java\n which can be obtained at http://xerces.apache.org/xerces2-j/", "fpXmap", 1);
    }

    private void loadXMap(String fName, String xName) {
        String fullName = null;
        String fpfile = null;
        String dataDir = this.config.getDataDirectory();
        String startDir = null;
        if (!this.removeCurrentMapping()) {
            return;
        }
        String fpName = fName;
        if (fpName != null && xName != null) {
            String fpDir = String.valueOf(dataDir) + fpName;
            fullName = String.valueOf(fpDir) + System.getProperty("file.separator") + FormatType.fullName(3, xName);
        } else {
            startDir = fpName != null ? String.valueOf(dataDir) + fpName : dataDir;
            JFileChooser fps = new JFileChooser(startDir);
            fps.setFileFilter(new fpFormatFilter(3));
            fps.setFileSelectionMode(2);
            int result = fps.showOpenDialog(null);
            if (result == 0) {
                File selFile = fps.getSelectedFile();
                fullName = selFile.getAbsolutePath();
            } else {
                return;
            }
        }
        if (fullName == null) {
            return;
        }
        this.resetLog();
        File testExist = new File(fullName);
        if (!testExist.exists()) {
            fpXMap.showMessage("Load fpx file", "File " + fullName + " can not be found");
            return;
        }
        if (!testExist.canRead()) {
            fpXMap.showMessage("Load fpx file", "Read permission denied for file " + fullName);
            return;
        }
        fpfile = testExist.getParentFile().getName();
        fpxReader fr = new fpxReader();
        fr.setLog(this.log);
        LinkedList<fpX> mapList = fr.parseFPX(fullName);
        if (mapList == null) {
            if (this.log != null) {
                this.log.writeDebug("Error parsing content of " + fullName);
            }
        } else {
            String filename = fr.getFilename().trim();
            if (filename != null) {
                if (fpfile != null && !filename.equals(fpfile)) {
                    filename = fpfile;
                }
            } else {
                filename = fpfile;
            }
            if (fName != null && !fName.equals(filename)) {
                if (this.log != null) {
                    this.log.writeError("Loaded filePro file name " + filename + " does not match current filePro file name " + fName);
                    this.log.writeError("Loaded filePro file name ignored. Note that loaded field mapping may not match current filePro file.");
                }
                fpXMap.showError("FPX load warning", "Loaded filePro file name " + filename + " does not match current filePro file name " + fName + " and will be ignored.\n Note that loaded field mapping may not match current filePro file.");
            }
            this.autoPrcName = fr.getAutoName();
            this.outputPrcName = fr.getOutputName();
            this.xsdName = fr.getXSDName();
            if (filename != null) {
                this.displayMainFileProFile(filename);
                this.mainFilename = filename;
                this.openItem.setEnabled(true);
                this.saveItem.setEnabled(true);
                this.saveAsItem.setEnabled(true);
            }
            this.fpxName = this.xsdName;
            if (this.xsdName != null) {
                this.getAndParseXSDFile(this.xsdName, false);
            }
            int rows = mapList.size();
            Object[][] oa = new Object[rows][this.colNames.length];
            int row = 0;
            String path = null;
            String name = null;
            String newType = null;
            for (fpX f : mapList) {
                String s = f.getTag();
                if (s == null || s.isEmpty()) {
                    oa[row][fpXMap.PATH_COLUMN] = "";
                    oa[row][fpXMap.NAME_COLUMN] = "";
                } else {
                    int lastSlashPos = s.lastIndexOf(47);
                    if (lastSlashPos == -1) {
                        path = "";
                        name = s;
                    } else {
                        path = s.substring(0, lastSlashPos);
                        name = s.substring(lastSlashPos + 1);
                    }
                    oa[row][fpXMap.PATH_COLUMN] = path;
                    oa[row][fpXMap.NAME_COLUMN] = name;
                }
                s = f.getTagType();
                oa[row][fpXMap.TAGTYPE_COLUMN] = s == null ? "" : s;
                s = f.getDataType();
                oa[row][fpXMap.DATATYPE_COLUMN] = s == null ? "" : s;
                newType = s;
                s = f.getExpand();
                oa[row][fpXMap.EXPAND_COLUMN] = s == null || s.isEmpty() || s.trim().equalsIgnoreCase("false") ? Boolean.valueOf(false) : (s.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false));
                s = f.getField();
                oa[row][fpXMap.FILEPRO_COLUMN] = s == null ? "" : s;
                s = f.getMinOccurs();
                oa[row][fpXMap.MIN_COLUMN] = s == null ? "" : s;
                s = f.getMaxOccurs();
                oa[row][fpXMap.MAX_COLUMN] = s == null ? "" : s;
                s = f.getRestrictions();
                oa[row][fpXMap.RESTRICT_COLUMN] = s == null ? "" : s;
                ++row;
                s = f.getOldType();
                if (s == null) continue;
                this.addTypeToList(path, name, s, newType);
            }
            this.status.setWest(fullName);
            this.xmapModel.setDataVector(oa, this.colNames);
            this.setPreferredColumnWidths();
            this.xmapModel.setXSDName(this.xsdName);
            this.loadFilename = fullName;
            this.tableChanged = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveXMap(boolean newName) {
        FileWriter fw;
        String fullName;
        String dataDir = this.config.getDataDirectory();
        fpXMapSaveDialog saveDialog = new fpXMapSaveDialog(null, dataDir, null, this.mainFilename, this.xsdName, this.fpxName);
        if (this.loadFilename == null || newName) {
            saveDialog.init();
            if (!saveDialog.getExitValue()) return;
            this.mainFilename = saveDialog.getFileProFilename();
            this.autoPrcName = saveDialog.getAutoName();
            this.outputPrcName = saveDialog.getOutputName();
            this.xsdName = saveDialog.getXsdName().replace('\\', '/');
            this.fpxName = saveDialog.getFpxName();
            if (dataDir.endsWith("/") || dataDir.endsWith("\\")) {
                dataDir = dataDir.substring(0, dataDir.length() - 1);
            }
            this.fpxPath = String.valueOf(dataDir) + System.getProperty("file.separator") + this.mainFilename + System.getProperty("file.separator");
            if (this.log != null) {
                this.log.writeDebug("filePro file:  " + this.mainFilename);
                this.log.writeDebug("Automatic processing:  " + this.autoPrcName);
                this.log.writeDebug("Output processing:  " + this.outputPrcName);
                this.log.writeDebug("Mapped XSD:  " + this.xsdName);
                this.log.writeDebug("Save name for fpx file:  " + this.fpxName);
                this.log.writeDebug("save directory for fpx file: " + this.fpxPath);
            }
            fullName = String.valueOf(this.fpxPath) + FormatType.fullName(3, this.fpxName);
        } else {
            fullName = this.loadFilename;
        }
        File f = new File(fullName);
        try {
            fw = new FileWriter(f, false);
        }
        catch (IOException e) {
            if (this.log != null) {
                this.log.writeError("Could not open file " + f.getAbsolutePath() + " to save cross mapping .");
                this.log.logException(e);
            }
            fpXMap.showError("Saving filePro to XSD mapping", "Could not open file " + f.getAbsolutePath() + " to save cross mapping .");
            return;
        }
        try {
            fw.write("<fpxmap>\n");
            fw.write("<file>" + this.mainFilename + "</file>\n");
            if (this.autoPrcName != null || this.outputPrcName != null) {
                fw.write("<prc>\n");
                if (this.autoPrcName != null) {
                    fw.write("<auto>" + this.autoPrcName + "</auto>\n");
                }
                if (this.outputPrcName != null) {
                    fw.write("<output>" + this.outputPrcName + "</output>\n");
                }
                fw.write("</prc>\n");
            }
            if (this.xsdName != null) {
                fw.write("<xsd>" + this.xsdName + "</xsd>\n");
            }
            fw.write("<mapping>\n");
            String path = null;
            String name = null;
            int rows = this.xmapModel.getRowCount();
            int r = 0;
            while (r < rows) {
                path = (String)this.xmapModel.getValueAt(r, PATH_COLUMN);
                name = (String)this.xmapModel.getValueAt(r, NAME_COLUMN);
                String s = path == null || path.equals("") ? name : String.valueOf(path) + "/" + name;
                if (s != null && !s.isEmpty()) {
                    boolean expandFlag;
                    fw.write("<xmap>");
                    fw.write("<tag>" + s.trim() + "</tag>\n");
                    s = (String)this.xmapModel.getValueAt(r, DATATYPE_COLUMN);
                    if (s == null || s.isEmpty()) {
                        s = "String";
                    }
                    fw.write("<dataType>" + s.trim() + "</dataType>\n");
                    s = (String)this.xmapModel.getValueAt(r, TAGTYPE_COLUMN);
                    if (s == null || s.isEmpty()) {
                        s = "E";
                    }
                    s = s.trim();
                    fw.write("<tagType>" + s + "</tagType>\n");
                    if (s.equalsIgnoreCase("E") || s.equalsIgnoreCase("A")) {
                        s = (String)this.xmapModel.getValueAt(r, MIN_COLUMN);
                        if (s == null || s.isEmpty()) {
                            s = "0";
                        }
                        fw.write("<minOccurs>" + s.trim() + "</minOccurs>\n");
                        s = (String)this.xmapModel.getValueAt(r, MAX_COLUMN);
                        if (s == null || s.isEmpty()) {
                            s = "1";
                        }
                        fw.write("<maxOccurs>" + s.trim() + "</maxOccurs>\n");
                        s = (String)this.xmapModel.getValueAt(r, FILEPRO_COLUMN);
                        if (s != null && !s.isEmpty()) {
                            fw.write("<field>" + s.trim() + "</field>\n");
                        }
                        if ((s = (String)this.xmapModel.getValueAt(r, RESTRICT_COLUMN)) != null && !s.isEmpty()) {
                            fw.write("<restrictions>" + s.trim() + "</restrictions>\n");
                        }
                    }
                    if (expandFlag = ((Boolean)this.xmapModel.getValueAt(r, EXPAND_COLUMN)).booleanValue()) {
                        String oldType;
                        String dataType = (String)this.xmapModel.getValueAt(r, DATATYPE_COLUMN);
                        if (!dataType.equals(oldType = this.findOldType(path, name, dataType))) {
                            fw.write("<oldType>" + oldType + "</oldType>\n");
                        }
                        s = "true";
                    }
                    if (!expandFlag) {
                        s = "false";
                    }
                    fw.write("<expand>" + s.trim() + "</expand>\n");
                    fw.write("</xmap>\n");
                }
                ++r;
            }
            fw.write("</mapping>\n");
            fw.write("</fpxmap>\n");
            fw.close();
            this.loadFilename = fullName;
            this.tableChanged = false;
            return;
        }
        catch (IOException e2) {
            if (this.log != null) {
                this.log.writeError("Error writing to file " + f.getAbsolutePath());
                this.log.logException(e2);
            }
            fpXMap.showError("IOException", "Error writing to file " + f.getAbsolutePath());
            return;
        }
        catch (Exception e3) {
            fpXMap.showError("Exception writing mapping table", e3.toString());
        }
    }

    public void setupMenu() {
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newItem = new JMenuItem("New");
        this.newItem.setEnabled(true);
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (fpXMap.this.removeCurrentMapping()) {
                    if (!fpXMap.this.insertRowBeforeButton.isVisible()) {
                        fpXMap.this.insertRowBeforeButton.setVisible(true);
                    }
                    if (!fpXMap.this.insertRowAfterButton.isVisible()) {
                        fpXMap.this.insertRowAfterButton.setVisible(true);
                    }
                    if (!fpXMap.this.deleteRowButton.isVisible()) {
                        fpXMap.this.deleteRowButton.setVisible(true);
                    }
                }
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem = new JMenuItem("Open");
        this.openItem.setEnabled(true);
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.loadXMap(null, null);
            }
        });
        this.fileMenu.add(this.openItem);
        this.saveItem = new JMenuItem("Save");
        this.saveItem.setEnabled(false);
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.saveXMap(false);
            }
        });
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem("saveAs");
        this.saveAsItem.setEnabled(false);
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.saveXMap(true);
            }
        });
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem("eXit");
        this.exitItem.setEnabled(true);
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (fpXMap.this.cleanup()) {
                    fpXMap.this.xmapFrame.dispose();
                    fpXMap.this.sFrame.dispose();
                    System.exit(0);
                }
            }
        });
        this.fileMenu.add(this.exitItem);
        this.fileproMenu = new JMenu("filePro");
        this.mainFileItem = new JMenuItem("main File map");
        this.mainFileItem.setEnabled(true);
        this.mainFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.setMainFileProFile();
            }
        });
        this.fileproMenu.add(this.mainFileItem);
        this.lookupFileItem = new JMenuItem("Lookup file map");
        this.lookupFileItem.setEnabled(false);
        this.lookupFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.showLookupFile();
            }
        });
        this.fileproMenu.add(this.lookupFileItem);
        this.prcItem = new JMenuItem("view Processing table");
        this.prcItem.setEnabled(false);
        this.prcItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.showProcessingTable();
            }
        });
        this.fileproMenu.add(this.prcItem);
        this.xsdMenu = new JMenu("XSD");
        this.xsdItem = new JMenuItem("parse XSD file");
        this.xsdItem.setEnabled(true);
        this.xsdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.resetLog();
                fpXMap.this.getAndParseXSDFile(null, true);
                fpXMap.this.xmapModel.setXSDName(fpXMap.this.xsdName);
            }
        });
        this.xsdMenu.add(this.xsdItem);
        this.xsdViewItem = new JMenuItem("View raw XSD");
        this.xsdViewItem.setEnabled(true);
        this.xsdViewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File selected = fpXMap.selectXSDFile(fpXMap.this.xmapFrame);
                if (selected != null) {
                    fpLogViewer fv = new fpLogViewer(selected.getAbsolutePath());
                    fv.init();
                }
            }
        });
        this.xsdMenu.add(this.xsdViewItem);
        this.helpMenu = new JMenu("Help");
        this.helpItem = new JMenuItem("Help Contents");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new fpHelp(fpXMap.helpNavFile, xmapProp).setVisible(true);
            }
        });
        this.helpItem.setEnabled(true);
        this.helpMenu.add(this.helpItem);
        this.logViewItem = new JMenuItem("view Log");
        this.logViewItem.setEnabled(true);
        this.logViewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpLogViewer lv = new fpLogViewer(fpXMap.this.logName);
                lv.init();
            }
        });
        this.helpMenu.add(this.logViewItem);
        this.versionItem = new JMenuItem("About");
        this.versionItem.setEnabled(true);
        this.versionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fpXMap.this.showVersion();
            }
        });
        this.helpMenu.add(this.versionItem);
        this.menubar.add(this.fileMenu);
        this.menubar.add(this.fileproMenu);
        this.menubar.add(this.xsdMenu);
        this.menubar.add(this.helpMenu);
    }

    private void setupFileProPanel() {
        this.fileProPanel = new JInternalFrame("filePro file", true, false, true);
        this.fileProPanel.setMaximizable(false);
        this.initFPTable();
        this.fileProPanel.setVisible(true);
    }

    private void setupXSDPanel() {
        this.xsdPanel = new JInternalFrame("xMap Editor", true, false, true);
        this.xsdPanel.setMaximizable(false);
        this.initTable();
        this.xsdPanel.setVisible(true);
    }

    private void buildDisplayPanel() {
        this.displayPanel = new JSplitPane(0);
        this.displayPanel.setVisible(true);
        this.setupFileProPanel();
        this.displayPanel.setTopComponent(this.fileProPanel);
        this.setupXSDPanel();
        this.displayPanel.setBottomComponent(this.xsdPanel);
        this.displayPanel.setDividerLocation(0.5);
        this.displayPanel.setResizeWeight(0.5);
    }

    JFrame setupMainFrame() {
        this.sFrame = new JFrame();
        this.setupMenu();
        this.sFrame.setJMenuBar(this.menubar);
        this.status = new fpStatusBar();
        this.sFrame.getContentPane().add((Component)this.status, "South");
        this.buildDisplayPanel();
        this.sFrame.getContentPane().add((Component)this.displayPanel, "Center");
        this.sFrame.setTitle("XSD to filePro Mapping Tool");
        this.sFrame.setDefaultCloseOperation(0);
        this.sFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (fpXMap.this.cleanup()) {
                    fpXMap.this.sFrame.dispose();
                    System.exit(0);
                }
            }
        });
        return this.sFrame;
    }

    boolean setupHelp() {
        return true;
    }

    private void init() {
        int xpos = 200;
        int ypos = 200;
        int width = 600;
        int height = 400;
        this.setupLogging();
        if (!this.setupHelp()) {
            System.exit(0);
        }
        this.config = new fpConfig(this.log);
        String userHome = System.getProperty("user.home");
        this.propFileName = String.valueOf(userHome) + System.getProperty("file.separator") + "fpxmap.cfg";
        xmapProp = new Properties();
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.propFileName));
            xmapProp.load(in);
        }
        catch (FileNotFoundException e) {
            fpXMap.showMessage("Load Properties", "Could not find properties file " + this.propFileName + " . Using default values.");
            xmapProp.setProperty("xsdDirectory", userHome);
        }
        catch (IOException e2) {
            fpXMap.showMessage("Load Properties", "Error reading properties file " + this.propFileName + " . Using default values.");
            xmapProp.setProperty("xsdDirectory", userHome);
        }
        if (xmapProp != null) {
            String s = xmapProp.getProperty("xpos");
            if (s != null) {
                xpos = Integer.parseInt(s);
            }
            if ((s = xmapProp.getProperty("ypos")) != null) {
                ypos = Integer.parseInt(s);
            }
            if ((s = xmapProp.getProperty("width")) != null) {
                width = Integer.parseInt(s);
            }
            if ((s = xmapProp.getProperty("height")) != null) {
                height = Integer.parseInt(s);
            }
        }
        this.xmapFrame = this.setupMainFrame();
        this.xmapFrame.setBounds(xpos, ypos, width, height);
        this.xmapFrame.setVisible(true);
    }

    public static void main(String[] args) {
        fpXMap fpx = new fpXMap();
        fpx.init();
    }
}

