/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.FormatType;
import com.fptech.xml.XSDMapping.filepro.fpFileSelect;
import com.fptech.xml.XSDMapping.filepro.fpFormatSelect;
import com.fptech.xml.XSDMapping.filepro.fpXMap;
import com.fptech.xml.XSDMapping.filepro.fpXSavePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class fpXMapSaveDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JLabel fileLabel;
    JTextField fileField;
    JButton fileButton;
    JLabel autoLabel;
    JTextField autoField;
    JButton autoButton;
    JLabel outputLabel;
    JTextField outputField;
    JButton outputButton;
    JLabel xsdLabel;
    JTextField xsdField;
    JButton xsdButton;
    JLabel fpxLabel;
    JTextField fpxField;
    JButton fpxButton;
    JButton saveButton;
    JButton cancelButton;
    String fileProFilename = null;
    String autoName = null;
    String outputName = null;
    String xsdName = null;
    String fpxName = null;
    String fpxPath = null;
    String dataDir = null;
    String saveDir = null;
    String formatDirectory = null;
    boolean exitValue = false;

    public fpXMapSaveDialog(Frame parent, String dataDir, String saveDir, String fp, String xsd, String fpx) {
        super(parent, true);
        this.fileProFilename = fp;
        this.xsdName = xsd;
        this.fpxName = fpx;
        this.dataDir = dataDir;
        this.saveDir = saveDir;
    }

    private void setFormatDirectory() {
        this.formatDirectory = this.dataDir.endsWith("\\") || this.dataDir.endsWith("/") ? String.valueOf(this.dataDir) + this.getFileProFilename() : String.valueOf(this.dataDir) + System.getProperty("file.separator") + this.getFileProFilename();
    }

    public boolean getExitValue() {
        return this.exitValue;
    }

    public String getFileProFilename() {
        return this.fileProFilename;
    }

    public String getAutoName() {
        return this.autoName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getXsdName() {
        return this.xsdName;
    }

    public String getFpxName() {
        return this.fpxName;
    }

    public String getFpxPath() {
        return this.fpxPath;
    }

    public void setFileProFilename(String f) {
        this.fileProFilename = f;
    }

    public void setAutoName(String f) {
        this.autoName = f;
    }

    public void setOutputName(String f) {
        this.outputName = f;
    }

    public void setXsdName(String f) {
        this.xsdName = f;
    }

    public void setFpxName(String f) {
        this.fpxName = f;
    }

    public void setFpxPath(String p) {
        this.fpxPath = p;
    }

    private String browseForXSD() {
        File selected = fpXMap.selectXSDFile(this);
        if (selected != null) {
            return selected.getAbsolutePath();
        }
        return null;
    }

    private String selectMainFileProFile() {
        fpFileSelect fps = new fpFileSelect(null, this.dataDir);
        String selName = fps.getSelectedName();
        return selName;
    }

    public void setupComponents() {
        double widestPreferred = 0.0;
        this.fileLabel = new JLabel("FilePro file");
        double w = this.fileLabel.getPreferredSize().getWidth();
        if (w > widestPreferred) {
            widestPreferred = w;
        }
        this.fileField = new JTextField(24);
        if (this.fileProFilename != null) {
            this.fileField.setText(this.fileProFilename);
        }
        this.fileField.setMinimumSize(this.fileField.getPreferredSize());
        this.fileField.setVisible(true);
        this.fileButton = new JButton("Browse");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = fpXMapSaveDialog.this.selectMainFileProFile();
                if (s != null) {
                    fpXMapSaveDialog.this.fileField.setText(s);
                } else {
                    fpXMapSaveDialog.this.fileField.setText("");
                }
            }
        });
        if (this.fileProFilename != null) {
            this.fileButton.setEnabled(false);
        }
        this.autoLabel = new JLabel("Automatic Processing");
        w = this.autoLabel.getPreferredSize().getWidth();
        if (w > widestPreferred) {
            widestPreferred = w;
        }
        this.autoField = new JTextField(24);
        this.autoField.setMinimumSize(this.autoField.getPreferredSize());
        this.autoField.setVisible(true);
        this.autoButton = new JButton("Browse");
        this.autoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fn = fpXMapSaveDialog.this.fileField.getText();
                if (fn == null || fn.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "filePro file name must be set");
                } else {
                    fpXMapSaveDialog.this.setFormatDirectory();
                    fpFormatSelect fps = new fpFormatSelect();
                    fps.init(fpXMapSaveDialog.this.formatDirectory, fpXMapSaveDialog.this.fileProFilename, 2, 0);
                    int result = fps.open();
                    if (result == 0) {
                        String selName;
                        fpXMapSaveDialog.this.autoName = selName = FormatType.baseFilename(2, fps.getSelectedName());
                        fpXMapSaveDialog.this.autoField.setText(selName);
                    } else {
                        fpXMapSaveDialog.this.autoField.setText("");
                    }
                }
            }
        });
        this.outputLabel = new JLabel("Output Processing");
        w = this.outputLabel.getPreferredSize().getWidth();
        if (w > widestPreferred) {
            widestPreferred = w;
        }
        this.outputField = new JTextField(24);
        this.outputField.setMinimumSize(this.outputField.getPreferredSize());
        this.outputField.setVisible(true);
        this.outputButton = new JButton("Browse");
        this.outputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fn = fpXMapSaveDialog.this.fileField.getText();
                if (fn == null || fn.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "filePro file name must be set");
                } else {
                    fpXMapSaveDialog.this.setFormatDirectory();
                    fpFormatSelect fps = new fpFormatSelect();
                    fps.init(fpXMapSaveDialog.this.formatDirectory, fpXMapSaveDialog.this.fileProFilename, 2, 0);
                    int result = fps.open();
                    if (result == 0) {
                        String selName;
                        fpXMapSaveDialog.this.outputName = selName = FormatType.baseFilename(2, fps.getSelectedName());
                        fpXMapSaveDialog.this.outputField.setText(selName);
                    } else {
                        fpXMapSaveDialog.this.outputField.setText("");
                    }
                }
            }
        });
        this.xsdLabel = new JLabel("XSD file");
        w = this.xsdLabel.getPreferredSize().getWidth();
        if (w > widestPreferred) {
            widestPreferred = w;
        }
        this.xsdField = new JTextField(24);
        this.xsdField.setMinimumSize(this.xsdField.getPreferredSize());
        this.xsdField.setEnabled(false);
        this.xsdField.setVisible(true);
        if (this.xsdName != null) {
            this.xsdField.setText(this.xsdName);
        }
        this.xsdButton = new JButton("Browse");
        this.xsdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMapSaveDialog.this.xsdName = fpXMapSaveDialog.this.browseForXSD();
                if (fpXMapSaveDialog.this.xsdName != null) {
                    fpXMapSaveDialog.this.xsdField.setText(fpXMapSaveDialog.this.xsdName);
                } else {
                    fpXMapSaveDialog.this.xsdField.setText("");
                }
            }
        });
        this.xsdButton.setEnabled(false);
        this.fpxLabel = new JLabel("Save file");
        w = this.fpxLabel.getPreferredSize().getWidth();
        if (w > widestPreferred) {
            widestPreferred = w;
        }
        this.fpxField = new JTextField(24);
        if (this.fpxName != null) {
            this.fpxField.setText(this.fpxName);
        }
        this.fpxField.setMinimumSize(this.fpxField.getPreferredSize());
        this.fpxField.setVisible(true);
        this.fpxButton = new JButton("Browse");
        this.fpxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fn = fpXMapSaveDialog.this.fileField.getText();
                if (fn == null || fn.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "filePro file name must be set");
                } else {
                    String formatDir = null;
                    if (fpXMapSaveDialog.this.saveDir != null) {
                        formatDir = fpXMapSaveDialog.this.saveDir;
                    } else {
                        fpXMapSaveDialog.this.setFormatDirectory();
                        formatDir = fpXMapSaveDialog.this.formatDirectory;
                    }
                    fpFormatSelect fps = new fpFormatSelect();
                    fps.init(formatDir, fpXMapSaveDialog.this.fileProFilename, 3, 1);
                    int result = fps.open();
                    if (result == 0) {
                        String selName;
                        fpXMapSaveDialog.this.fpxName = selName = FormatType.fullName(3, fps.getSelectedName());
                        fpXMapSaveDialog.this.fpxPath = fps.getSelectedPath();
                        fpXMapSaveDialog.this.fpxField.setText(selName);
                    } else {
                        fpXMapSaveDialog.this.fpxField.setText("");
                    }
                }
            }
        });
        Dimension d = this.fileLabel.getPreferredSize();
        d.setSize(widestPreferred, d.getHeight());
        this.fileLabel.setPreferredSize(d);
        this.fileLabel.setMaximumSize(d);
        d = this.autoLabel.getPreferredSize();
        d.setSize(widestPreferred, d.getHeight());
        this.autoLabel.setPreferredSize(d);
        this.autoLabel.setMaximumSize(d);
        d = this.outputLabel.getPreferredSize();
        d.setSize(widestPreferred, d.getHeight());
        this.outputLabel.setPreferredSize(d);
        this.outputLabel.setMaximumSize(d);
        d = this.xsdLabel.getPreferredSize();
        d.setSize(widestPreferred, d.getHeight());
        this.xsdLabel.setPreferredSize(d);
        this.xsdLabel.setMaximumSize(d);
        d = this.fpxLabel.getPreferredSize();
        d.setSize(widestPreferred, d.getHeight());
        this.fpxLabel.setPreferredSize(d);
        this.fpxLabel.setMaximumSize(d);
    }

    private JPanel buildButtonBar() {
        JPanel p = new JPanel();
        this.saveButton = new JButton("Save");
        this.cancelButton = new JButton("Cancel");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMapSaveDialog.this.fileProFilename = fpXMapSaveDialog.this.fileField.getText();
                if (fpXMapSaveDialog.this.fileProFilename.isEmpty()) {
                    fpXMapSaveDialog.this.fileProFilename = null;
                }
                fpXMapSaveDialog.this.autoName = fpXMapSaveDialog.this.autoField.getText();
                if (fpXMapSaveDialog.this.autoName.isEmpty()) {
                    fpXMapSaveDialog.this.autoName = null;
                }
                fpXMapSaveDialog.this.outputName = fpXMapSaveDialog.this.outputField.getText();
                if (fpXMapSaveDialog.this.outputName.isEmpty()) {
                    fpXMapSaveDialog.this.outputName = null;
                }
                fpXMapSaveDialog.this.xsdName = fpXMapSaveDialog.this.xsdField.getText();
                if (fpXMapSaveDialog.this.xsdName.isEmpty()) {
                    fpXMapSaveDialog.this.xsdName = null;
                }
                fpXMapSaveDialog.this.fpxName = fpXMapSaveDialog.this.fpxField.getText();
                if (fpXMapSaveDialog.this.fpxName.isEmpty()) {
                    fpXMapSaveDialog.this.fpxName = null;
                }
                fpXMapSaveDialog.this.exitValue = true;
                fpXMapSaveDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpXMapSaveDialog.this.exitValue = false;
                fpXMapSaveDialog.this.setVisible(false);
            }
        });
        p.add(this.saveButton);
        p.add(this.cancelButton);
        p.setMaximumSize(p.getPreferredSize());
        p.setVisible(true);
        return p;
    }

    public void layoutComponents() {
        Container contentPane = this.getContentPane();
        fpXSavePanel fileP = new fpXSavePanel(this.fileLabel, this.fileField, this.fileButton);
        fpXSavePanel autoP = new fpXSavePanel(this.autoLabel, this.autoField, this.autoButton);
        fpXSavePanel outputP = new fpXSavePanel(this.outputLabel, this.outputField, this.outputButton);
        fpXSavePanel xsdP = new fpXSavePanel(this.xsdLabel, this.xsdField, this.xsdButton);
        fpXSavePanel fpxP = new fpXSavePanel(this.fpxLabel, this.fpxField, this.fpxButton);
        Box b = Box.createVerticalBox();
        fileP.setMaximumSize(fileP.getPreferredSize());
        autoP.setMaximumSize(autoP.getPreferredSize());
        outputP.setMaximumSize(outputP.getPreferredSize());
        xsdP.setMaximumSize(xsdP.getPreferredSize());
        fpxP.setMaximumSize(fpxP.getPreferredSize());
        b.add(fileP);
        b.add(autoP);
        b.add(outputP);
        b.add(xsdP);
        b.add(fpxP);
        JPanel bbar = this.buildButtonBar();
        bbar.setMaximumSize(bbar.getPreferredSize());
        contentPane.add((Component)b, "Center");
        contentPane.add((Component)bbar, "South");
    }

    public void init() {
        this.setBounds(100, 100, 600, 250);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        this.setupComponents();
        this.layoutComponents();
        this.setTitle("filepro to XSD Map Save");
        this.setVisible(true);
    }
}

