/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

public class EditType {
    public static final int NOEDIT = 0;
    public static final int HMS = 1;
    public static final int TIME = 2;
    public static final int HM = 3;
    public static final int SPCPFCB = 4;
    public static final int BLKFLD = 5;
    public static final int SPECIAL = 6;
    public static final int BINARY = 7;
    public static final int ACCFLD = 8;
    public static final int FLOATING = 9;
    public static final int NUMERIC = 10;
    public static final int YMD = 21;
    public static final int DMY = 22;
    public static final int MDY = 23;
    public static final int S_YMD = 24;
    public static final int S_DMY = 25;
    public static final int S_MDY = 26;
    public static final int YYMD = 27;
    public static final int DMYY = 28;
    public static final int MDYY = 29;
    public static final int S_YYMD = 30;
    public static final int S_DMYY = 31;
    public static final int S_MDYY = 32;
    public static final int FLOATCOM = 33;
    public static final int NUMCOMMA = 34;
    public static final int UPLOW = 48;
    public static final int LOWUP = 49;
    public static final String[] systemNames = new String[]{"*", "HMS", "TIME", "HM", "", "", "", "", "", "F", ".0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", "", "", "YMD", "DMY", "MDY", "YMD/", "DMY/", "MDY/", "YYMD", "DMYY", "MDYY", "YYMD/", "DMYY/", "MDYY/", ",F", ",0", ",1", ",2", ",3", ",4", ",5", ",6", ",7", ",8", "", "", "", "", "", "UPLOW", "LOWUP"};
    int type = 0;
    String name;
    String mask;

    public static String getSystemEditName(int num) {
        if (num < 0) {
            String string = "Invalid Edit Type";
        }
        String retStr = num >= systemNames.length ? "user edit" : systemNames[num];
        return retStr;
    }

    public static int getTypeFromName(String name) {
        int retval = 0;
        if (name != null) {
            if ((name = name.trim()).equals("")) {
                retval = 0;
            } else {
                int i = 0;
                while (i < systemNames.length) {
                    if (name.equalsIgnoreCase(systemNames[i])) {
                        retval = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        return retval;
    }

    public EditType() {
        this.type = 0;
        this.name = "*";
    }

    public EditType(int edtype) {
        this.type = edtype;
        if (this.type <= 49) {
            this.name = systemNames[this.type];
        }
    }

    public int getType() {
        return this.type;
    }

    public String getEditName() {
        return this.name;
    }

    public boolean isDateType() {
        return this.type >= 21 && this.type <= 32;
    }

    public boolean isNumericType() {
        return this.type >= 9 && this.type <= 18;
    }

    public boolean isCommaType() {
        return this.type >= 33 && this.type <= 42;
    }

    public boolean isTimeType() {
        return this.type >= 1 && this.type <= 3;
    }

    public int getFractDigits() {
        int retval = 0;
        if (this.type > 10 && this.type < 18) {
            retval = this.type - 10;
        } else if (this.type > 34 && this.type < 42) {
            retval = this.type - 34;
        }
        return retval;
    }

    public int getMonthRelativePosition() {
        if (this.type == 23 || this.type == 26 || this.type == 29 || this.type == 32) {
            return 0;
        }
        return 1;
    }

    public int getDateRelativePosition() {
        if (this.type == 22 || this.type == 25 || this.type == 28 || this.type == 31) {
            return 0;
        }
        if (this.type == 23 || this.type == 26 || this.type == 29 || this.type == 32) {
            return 1;
        }
        return 2;
    }

    public int getYearRelativePosition() {
        if (this.type == 21 || this.type == 24 || this.type == 27 || this.type == 30) {
            return 0;
        }
        return 2;
    }
}

