/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.PRCLineForm;
import com.fptech.xml.XSDMapping.filepro.PRCTable;
import com.fptech.xml.XSDMapping.filepro.fpStatusBar;
import com.fptech.xml.XSDMapping.filepro.fpXLog;
import com.fptech.xml.XSDMapping.filepro.fpXMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PRCDialog
extends JDialog {
    String prcFile;
    fpXLog log;
    JScrollPane jsp = null;
    PRCTable pt = null;
    fpStatusBar status;
    int delay = 30000;
    int lastFoundLine = -1;
    String lastSearchString = null;
    static final int NOWHERE = 0;
    static final int LABEL_FIELD = 1;
    static final int IF_FIELD = 2;
    static final int THEN_FIELD = 3;
    private static final long serialVersionUID = 1L;
    ActionListener taskPerformer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            PRCDialog.this.showProperties();
        }
    };

    public PRCDialog(String fname, fpXLog log) {
        this.prcFile = fname;
        this.log = log;
    }

    JPanel searchPanel() {
        JPanel p = new JPanel();
        JLabel l = new JLabel("Search: ");
        final JTextField t = new JTextField(20);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PRCDialog.this.findNext(t.getText());
            }
        });
        JButton b = new JButton("Find Next");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PRCDialog.this.findNext(t.getText());
            }
        });
        p.add(l);
        p.add(t);
        p.add(b);
        return p;
    }

    public void setFileName(String fullpath) {
        this.prcFile = fullpath;
    }

    public String getFileName() {
        return this.prcFile;
    }

    int getCurrentLine() {
        int retval = 0;
        JScrollBar vsb = this.jsp.getVerticalScrollBar();
        int currentPos = vsb.getValue();
        int singleLine = vsb.getUnitIncrement();
        retval = currentPos / singleLine;
        fpXMap.showMessage("CurrentLine", Integer.toString(retval));
        return retval;
    }

    int findNext(String searchString) {
        int retval = 0;
        ArrayList<PRCLineForm> forms = this.pt.getFormList();
        JTextField jtf = null;
        int startLine = this.lastFoundLine + 1;
        int whereFound = 0;
        boolean labelOnly = false;
        if (searchString == null || searchString.equals("")) {
            return this.getCurrentLine();
        }
        if (searchString.startsWith("~")) {
            labelOnly = true;
            searchString = searchString.substring(1);
        }
        if (this.lastSearchString != null && !searchString.equals(this.lastSearchString)) {
            startLine = this.getCurrentLine();
        }
        this.lastSearchString = searchString;
        int i = startLine;
        while (i < this.pt.getNumberOfLines()) {
            PRCLineForm ptlf = forms.get(i);
            if (ptlf.getLabelText().contains(searchString)) {
                whereFound = 1;
                jtf = ptlf.getLabelField();
                break;
            }
            if (!labelOnly) {
                if (ptlf.getIfText().contains(searchString)) {
                    whereFound = 2;
                    jtf = ptlf.getIfField();
                    break;
                }
                if (ptlf.getThenText().contains(searchString)) {
                    whereFound = 3;
                    jtf = ptlf.getThenField();
                    break;
                }
            }
            ++i;
        }
        if (whereFound != 0) {
            this.lastFoundLine = retval = i + 1;
            this.scrollToLine(i, jtf, searchString);
        } else {
            fpXMap.showMessage("Find Next: " + searchString, "NotFound");
            this.lastFoundLine = -1;
        }
        return retval;
    }

    public void scrollToLine(int line, JTextField jtf, String text) {
        JScrollBar sb = this.jsp.getVerticalScrollBar();
        int position = line * PRCTable.getPrcLineHeight();
        sb.setValue(position);
        int startPoint = jtf.getText().indexOf(text);
        int endPoint = startPoint + text.length();
        jtf.requestFocus();
        jtf.setSelectionStart(startPoint);
        jtf.setSelectionEnd(endPoint);
        this.jsp.revalidate();
    }

    private void showProperties() {
        JScrollBar sb = this.jsp.getVerticalScrollBar();
        String text = "Min " + sb.getMinimum() + "\nMax " + sb.getMaximum() + "\nUnit Increment " + sb.getUnitIncrement() + "\nBlock Increment " + sb.getBlockIncrement();
        fpXMap.showMessage("Scrollbar Properties", text);
    }

    public void init() {
        Container contentPane = this.getContentPane();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        this.pt = new PRCTable(1, this.prcFile, this.log);
        if (this.pt.isOpen()) {
            int numPrcLines = this.pt.getNumberOfLines();
            int pHeight = PRCTable.getPrcLineHeight();
            int cHeight = numPrcLines > 10 ? pHeight * 12 : pHeight * (numPrcLines + 2);
            int cWidth = pHeight * 24;
            this.setBounds(100, 100, cWidth, cHeight);
            this.jsp = new JScrollPane(this.pt);
            this.jsp.setVerticalScrollBarPolicy(22);
            JScrollBar vbar = this.jsp.getVerticalScrollBar();
            vbar.setMaximum(numPrcLines * pHeight);
            vbar.setMinimum(0);
            vbar.setUnitIncrement(pHeight);
            vbar.setBlockIncrement(pHeight * 5);
            JPanel jp = new JPanel();
            jp.setLayout(new BorderLayout());
            jp.add((Component)this.jsp, "Center");
            this.status = new fpStatusBar();
            jp.add((Component)this.searchPanel(), "South");
            contentPane.add(jp);
            this.setTitle(this.prcFile);
            this.setVisible(true);
        } else {
            this.dispose();
        }
    }

    public static void main(String[] args) {
    }
}

