/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import java.io.FileNotFoundException;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class SimpleLinkListener1
implements HyperlinkListener {
    private JEditorPane pane;
    private JLabel statusBar;
    private Stack<String> browseList;

    public SimpleLinkListener1(JEditorPane jep, JLabel jl, Stack<String> browseList) {
        this.pane = jep;
        this.statusBar = jl;
        this.browseList = browseList;
    }

    public SimpleLinkListener1(JEditorPane jep) {
        this(jep, null, null);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        HyperlinkEvent.EventType type = he.getEventType();
        if (type == HyperlinkEvent.EventType.ENTERED) {
            if (this.statusBar != null) {
                this.statusBar.setText(he.getURL().toString());
            }
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            if (this.statusBar != null) {
                this.statusBar.setText(" ");
            }
        } else if (he instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)he;
            HTMLDocument doc = (HTMLDocument)this.pane.getDocument();
            doc.processHTMLFrameHyperlinkEvent(evt);
        } else {
            try {
                this.browseList.push(this.pane.getPage().toString());
                this.pane.setPage(he.getURL());
            }
            catch (FileNotFoundException fnfe) {
                this.pane.setText("Could not open file: <tt>" + he.getURL() + "</tt>.<hr>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

