/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.EditType;
import com.fptech.xml.XSDMapping.filepro.fpDate;
import com.fptech.xml.XSDMapping.filepro.fpFormatException;
import com.fptech.xml.XSDMapping.filepro.fpNumber;
import com.fptech.xml.XSDMapping.filepro.fpTime;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.text.BreakIterator;
import java.text.ParseException;

public class fpEdit
extends Applet {
    private static final long serialVersionUID = 1L;
    private static final int SYSTEM_EDIT_COUNT = 50;
    private static final int GLOBAL_EDIT_COUNT = 25;
    private static final int DEFAULT_LENGTH = 24;
    Image logo;
    String name;
    String description;
    String definition;
    String Prompt;

    private String doDate(String text, int edtype, int maxlen) throws ParseException, fpFormatException {
        fpDate dt = new fpDate();
        EditType ed1 = new EditType(edtype);
        dt.parse(text);
        return dt.format(ed1, maxlen);
    }

    private String doNumeric(String text, int edtype, int maxlen) throws ParseException, fpFormatException {
        fpNumber fp = new fpNumber();
        EditType ed1 = new EditType(edtype);
        fp.parse(text);
        return fp.format(ed1, maxlen);
    }

    private String doComma(String text, int edtype, int maxlen) throws ParseException, fpFormatException {
        fpNumber fp = new fpNumber();
        EditType ed1 = new EditType(edtype);
        fp.parse(text);
        return fp.format(ed1, maxlen);
    }

    private String doTime(String text, int edtype, int maxlen) throws ParseException, fpFormatException {
        fpTime tm = new fpTime();
        EditType ed1 = new EditType(edtype);
        tm.parse(text);
        return tm.format(ed1, maxlen);
    }

    private boolean isRoman(String text) {
        if (text.length() > 3) {
            return false;
        }
        if (text.charAt(0) != 'I') {
            return false;
        }
        if (text.length() == 2) {
            return text.charAt(1) == 'V' || text.charAt(1) == 'I';
        }
        return text.charAt(1) == 'I' && text.charAt(2) == 'I';
    }

    private String processWord(String text) {
        String retword = "";
        if (this.isRoman(text)) {
            retword = String.valueOf(retword) + text;
            return retword;
        }
        if ("DLMSdlms".indexOf(text.charAt(0)) != -1) {
            if (text.startsWith("Del") || text.startsWith("del") || text.startsWith("Mac") || text.startsWith("mac") || text.startsWith("San") || text.startsWith("San")) {
                retword = String.valueOf(retword) + text.substring(0, 1).toUpperCase();
                retword = String.valueOf(retword) + text.substring(1, 3);
                if (text.length() > 3) {
                    retword = String.valueOf(retword) + text.substring(3, 4);
                }
                if (text.length() > 4) {
                    retword = String.valueOf(retword) + text.substring(4).toLowerCase();
                }
                return retword;
            }
            if (text.startsWith("De") || text.startsWith("La") || text.startsWith("Le") || text.startsWith("Li") || text.startsWith("Lo") || text.startsWith("Mc")) {
                retword = String.valueOf(retword) + text.substring(0, 1).toUpperCase();
                retword = String.valueOf(retword) + text.substring(1, 2);
                if (text.length() > 2) {
                    retword = String.valueOf(retword) + text.substring(2, 3);
                }
                if (text.length() > 3) {
                    retword = String.valueOf(retword) + text.substring(3).toLowerCase();
                }
                return retword;
            }
        }
        retword = String.valueOf(retword) + text.substring(0, 1).toUpperCase();
        retword = String.valueOf(retword) + text.substring(1).toLowerCase();
        return retword;
    }

    private String doWord(String text, int edtype) {
        String retword = "";
        if (text.length() == 1) {
            retword = String.valueOf(retword) + text.toUpperCase();
        } else if (edtype == 48) {
            retword = String.valueOf(retword) + this.processWord(text);
        } else {
            retword = String.valueOf(retword) + text.substring(0, 1).toUpperCase();
            retword = String.valueOf(retword) + text.substring(1);
        }
        return retword;
    }

    private String doUplow(String text, int edtype) {
        String retword = "";
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            String testword = text.substring(start, end);
            int apostrophe = testword.indexOf(39);
            while (apostrophe != -1) {
                if (apostrophe != testword.length() - 1 && apostrophe != testword.length() - 2) {
                    String apword = testword.substring(0, apostrophe + 1);
                    retword = String.valueOf(retword) + this.doWord(apword, edtype);
                    apostrophe = testword.indexOf(39, apostrophe + 1);
                    testword = testword.substring(apostrophe + 1);
                    continue;
                }
                apostrophe = -1;
            }
            if (testword.length() > 0) {
                retword = String.valueOf(retword) + this.doWord(testword, edtype);
            }
            start = end;
            end = boundary.next();
        }
        return retword;
    }

    public String performSystem(String text, int edtype) throws ParseException, fpFormatException {
        return this.performSystem(text, edtype, text.length());
    }

    public String performSystem(String text, int edtype, int maxlen) throws ParseException, fpFormatException {
        String returnText = null;
        EditType et = new EditType(edtype);
        if (et.isDateType()) {
            returnText = this.doDate(text, edtype, maxlen);
        } else if (et.isNumericType()) {
            returnText = this.doNumeric(text, edtype, maxlen);
        } else if (et.isCommaType()) {
            returnText = this.doComma(text, edtype, maxlen);
        } else if (et.isTimeType()) {
            returnText = this.doTime(text, edtype, maxlen);
        } else {
            switch (edtype) {
                case 0: {
                    returnText = text;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    returnText = text;
                    break;
                }
                case 48: {
                    returnText = this.doUplow(text, 48);
                    break;
                }
                case 49: {
                    returnText = this.doUplow(text, 49);
                    break;
                }
                default: {
                    returnText = text;
                }
            }
        }
        return returnText;
    }

    private String performGlobal(String text, int edtype, int maxlen) {
        return text;
    }

    private String performLocal(String text, int edtype, int maxlen) {
        return text;
    }

    public String perform(String text, String edname) {
        int type = this.getTypeValue(edname);
        return this.perform(text, type, 24);
    }

    public String perform(String text, String edname, int maxlen) {
        int type = this.getTypeValue(edname);
        return this.perform(text, type, maxlen);
    }

    public String perform(String text, int edtype) {
        return this.perform(text, edtype, 24);
    }

    public String perform(String text, int edtype, int maxlen) {
        String retStr;
        block7: {
            retStr = null;
            try {
                try {
                    if (edtype < 50) {
                        retStr = this.performSystem(text, edtype, maxlen);
                        break block7;
                    }
                    if (edtype < 25) {
                        retStr = this.performGlobal(text, edtype, maxlen);
                        break block7;
                    }
                    retStr = this.performLocal(text, edtype, maxlen);
                }
                catch (ParseException e) {
                    System.out.println("ParseException: " + e);
                    retStr = null;
                }
                catch (fpFormatException f) {
                    System.out.println("Error: " + f);
                    retStr = null;
                }
            }
            catch (Throwable throwable) {}
        }
        return retStr;
    }

    public int getTypeValue(String typename) {
        String findname = typename.trim();
        int i = 0;
        while (i < EditType.systemNames.length) {
            if (findname.equalsIgnoreCase(EditType.systemNames[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void init() {
        this.logo = this.getImage(this.getCodeBase(), "fpeditbt.jpg");
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.logo, 0, 0, this);
    }
}

