/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class fpEnv {
    static String dataDefault = "/appl/filepro";
    static String progDefault = "/appl/fp";
    static String progPath = null;
    static String dataPath = null;
    static String dirPath = null;
    static String progHold = null;
    static String dataHold = null;
    static String dirHold = null;
    static boolean defaultChecked = false;

    private static void readDefaultFile() {
        String defName = null;
        File defFile = null;
        defaultChecked = true;
        if (fpEnv.isWindows()) {
            defName = "/fppath";
            dataDefault = "/appl/filepro";
            progDefault = "/appl/fp";
        } else {
            defName = "/etc/default/fppath";
            dataDefault = "/appl/filepro";
            progDefault = "/appl/fp";
        }
        defFile = new File(defName);
        if (defFile.exists() && defFile.canRead()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(defFile));
                progHold = in.readLine();
                dataHold = in.readLine();
                dirHold = in.readLine();
                if (progHold.equals("")) {
                    progHold = null;
                }
                if (dataHold.equals("")) {
                    dataHold = null;
                }
                if (dirHold.equals("")) {
                    dirHold = null;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (progPath == null) {
            progPath = progHold;
        }
        if (dirPath == null) {
            dirPath = dirHold;
        }
        if (dataPath == null) {
            if (dataHold != null && dataHold.length() == 1) {
                dataPath = String.valueOf(dataHold) + ":";
            }
            if (dirPath == null) {
                dataPath = dataPath == null ? dirPath : String.valueOf(dataPath) + dirPath;
            }
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static String getPFPROG() {
        if (progPath != null) {
            return progPath;
        }
        String result = System.getenv("PFPROG");
        if (result == null) {
            if (!defaultChecked) {
                fpEnv.readDefaultFile();
            }
        } else {
            progPath = result;
        }
        if (progPath == null) {
            progPath = progDefault;
        }
        if (fpEnv.isWindows() && progPath.length() == 1) {
            progPath = String.valueOf(progPath) + ":";
        }
        return progPath;
    }

    public static String getPFDATA() {
        if (dataPath != null) {
            return dataPath;
        }
        String result = System.getenv("PFPROG");
        if (result == null) {
            if (!defaultChecked) {
                fpEnv.readDefaultFile();
            }
        } else {
            dataPath = result;
        }
        if (dataPath == null) {
            dataPath = dataDefault;
        }
        if (fpEnv.isWindows() && dataPath.length() == 1) {
            dataPath = String.valueOf(dataPath) + ":";
        }
        return dataPath;
    }

    public static String getPFDIR() {
        return dirPath;
    }

    public static String getEnv(String base) {
        String s1 = "PF" + base;
        String s2 = "FP" + base;
        String result = null;
        result = System.getenv(s1);
        if (result == null) {
            result = System.getenv(s2);
        }
        return result;
    }
}

