/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.SimpleLinkListener1;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class fpHelp
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JEditorPane jep;
    private LinkedList<String> docList;
    private Stack<String> browseList;
    JLabel statusBar;
    int listPosition = 0;
    final Properties props;

    public fpHelp(String navFile, Properties propFile) {
        super("fpHelp");
        this.props = propFile;
        int xpos = 200;
        int ypos = 200;
        int width = 400;
        int height = 300;
        if (this.props != null) {
            String s = this.props.getProperty("help_xpos");
            if (s != null) {
                xpos = Integer.parseInt(s);
            }
            if ((s = this.props.getProperty("help_ypos")) != null) {
                ypos = Integer.parseInt(s);
            }
            if ((s = this.props.getProperty("help_width")) != null) {
                width = Integer.parseInt(s);
            }
            if ((s = this.props.getProperty("help_height")) != null) {
                height = Integer.parseInt(s);
            }
        }
        this.setBounds(xpos, ypos, width, height);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                fpHelp.this.savePosition();
            }
        });
        JPanel buttonPanel = new JPanel();
        this.initButtonPanel(buttonPanel);
        this.browseList = new Stack();
        this.docList = this.buildList(navFile);
        if (this.docList.isEmpty()) {
            System.out.println("Fatal Error: Could not build document list.");
            System.exit(64);
        }
        String startingUrl = this.docList.getFirst();
        this.statusBar = new JLabel(" ");
        this.jep = new JEditorPane();
        this.jep.setEditable(false);
        startingUrl = this.nameToUrl(startingUrl);
        this.statusBar.setText("Opening " + startingUrl);
        try {
            this.jep.setPage(startingUrl);
        }
        catch (Exception e) {
            this.statusBar.setText("Could not open " + startingUrl + ".  Using a blank.");
        }
        JScrollPane jsp = new JScrollPane(this.jep);
        this.getContentPane().add((Component)jsp, "Center");
        this.getContentPane().add((Component)buttonPanel, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.jep.addHyperlinkListener(new SimpleLinkListener1(this.jep, this.statusBar, this.browseList));
    }

    void savePosition() {
        if (this.props == null) {
            return;
        }
        Rectangle r = this.getBounds();
        int xpos = r.x;
        int ypos = r.y;
        int width = r.width;
        int height = r.height;
        this.props.setProperty("help_xpos", "" + xpos);
        this.props.setProperty("help_ypos", "" + ypos);
        this.props.setProperty("help_width", "" + width);
        this.props.setProperty("help_height", "" + height);
    }

    LinkedList<String> buildList(String listFile) {
        BufferedReader br;
        LinkedList<String> l = new LinkedList<String>();
        try {
            br = new BufferedReader(new FileReader(listFile));
        }
        catch (FileNotFoundException e) {
            return l;
        }
        try {
            String s;
            do {
                if ((s = br.readLine()) == null) continue;
                l.add(s);
            } while (s != null);
        }
        catch (IOException e2) {
            return l;
        }
        return l;
    }

    private String nameToUrl(String filename) {
        String urlString = null;
        try {
            File f = new File(filename);
            urlString = f.toURI().toURL().toString();
        }
        catch (Exception e) {
            urlString = "http://www.fptech.com";
        }
        return urlString;
    }

    private void initButtonPanel(JPanel p) {
        JButton homeButton = new JButton("Home");
        homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fpHelp.this.browseList.push(fpHelp.this.jep.getPage().toString());
                try {
                    fpHelp.this.jep.setPage(fpHelp.this.nameToUrl((String)fpHelp.this.docList.getFirst()));
                }
                catch (IOException ex) {
                    fpHelp.this.statusBar.setText("Error loading " + (String)fpHelp.this.docList.getFirst());
                }
            }
        });
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fpHelp.this.listPosition < fpHelp.this.docList.size() - 1) {
                    fpHelp.this.browseList.push(fpHelp.this.jep.getPage().toString());
                    ++fpHelp.this.listPosition;
                    try {
                        fpHelp.this.jep.setPage(fpHelp.this.nameToUrl((String)fpHelp.this.docList.get(fpHelp.this.listPosition)));
                    }
                    catch (IOException ex) {
                        fpHelp.this.statusBar.setText("Error loading " + (String)fpHelp.this.docList.getFirst());
                    }
                }
            }
        });
        JButton prevButton = new JButton("Prev");
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fpHelp.this.listPosition > 0) {
                    fpHelp.this.browseList.push(fpHelp.this.jep.getPage().toString());
                    --fpHelp.this.listPosition;
                    try {
                        fpHelp.this.jep.setPage(fpHelp.this.nameToUrl((String)fpHelp.this.docList.get(fpHelp.this.listPosition)));
                    }
                    catch (IOException ex) {
                        fpHelp.this.statusBar.setText("Error loading " + (String)fpHelp.this.docList.getFirst());
                    }
                }
            }
        });
        JButton backButton = new JButton("Back");
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fpHelp.this.browseList.isEmpty()) {
                    String page = fpHelp.this.nameToUrl((String)fpHelp.this.docList.getFirst());
                    try {
                        fpHelp.this.jep.setPage(page);
                    }
                    catch (IOException ex) {
                        fpHelp.this.statusBar.setText("Error loading " + page);
                    }
                } else {
                    String page = (String)fpHelp.this.browseList.pop();
                    try {
                        fpHelp.this.jep.setPage(page);
                    }
                    catch (IOException ex) {
                        fpHelp.this.statusBar.setText("Error loading " + page);
                    }
                }
            }
        });
        p.add(homeButton);
        p.add(nextButton);
        p.add(prevButton);
        p.add(backButton);
    }

    public static void main(String[] args) {
        new fpHelp(args[0], null).setVisible(true);
    }
}

