/*
 * Decompiled with CFR 0.152.
 */
package com.fptech.xml.XSDMapping.filepro;

import com.fptech.xml.XSDMapping.filepro.EditType;
import com.fptech.xml.XSDMapping.filepro.fpFormatException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class fpTime {
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void parse(String intext) throws ParseException {
        String hPart = null;
        String mPart = null;
        String sPart = null;
        String text = intext.trim();
        StringTokenizer st = new StringTokenizer(text, ":.");
        hPart = st.nextToken();
        if (st.hasMoreTokens()) {
            mPart = st.nextToken();
            if (st.hasMoreTokens()) {
                sPart = st.nextToken();
            }
        }
        this.hours = Integer.parseInt(hPart);
        if (mPart != null) {
            this.minutes = Integer.parseInt(mPart);
        }
        if (sPart != null) {
            this.seconds = Integer.parseInt(sPart);
        }
        if (this.hours < 0) {
            this.minutes *= -1;
            this.seconds *= -1;
        }
    }

    public String format(EditType edtype) throws fpFormatException {
        int spaceRequired = 8;
        if (edtype.getType() == 2) {
            spaceRequired = 8;
        } else {
            Integer hrs = new Integer(this.hours);
            String s_hrs = hrs.toString();
            if (edtype.getType() == 3) {
                spaceRequired = 3 + s_hrs.length();
                if (spaceRequired < 5) {
                    spaceRequired = 5;
                }
            } else {
                spaceRequired = 6 + s_hrs.length();
                if (spaceRequired < 8) {
                    spaceRequired = 8;
                }
            }
        }
        return this.format(edtype, spaceRequired);
    }

    public String format(EditType edtype, int outlen) throws fpFormatException {
        StringBuffer sbTime = new StringBuffer(outlen);
        if (!edtype.isTimeType()) {
            throw new fpFormatException("Invalid EditType for Time values");
        }
        this.minutes += this.seconds / 60;
        this.seconds %= 60;
        this.hours += this.minutes / 60;
        this.minutes %= 60;
        Integer hrs = new Integer(this.hours);
        String hourText = hrs.toString();
        int hourLen = hourText.length();
        if (edtype.getType() == 3) {
            if (outlen < hourLen + 3) {
                throw new fpFormatException(hourLen + 3);
            }
            if (hourLen < 2) {
                sbTime.append('0');
            }
            sbTime.append(this.hours);
            sbTime.append(":");
            if (this.minutes < 10) {
                sbTime.append('0');
            }
            sbTime.append(this.minutes);
        } else if (edtype.getType() == 1) {
            if (outlen < hourLen + 6) {
                throw new fpFormatException(hourLen + 6);
            }
            if (hourLen < 2) {
                sbTime.append('0');
            }
            sbTime.append(this.hours);
            sbTime.append(":");
            if (this.minutes < 10) {
                sbTime.append('0');
            }
            sbTime.append(this.minutes);
            sbTime.append(":");
            if (this.seconds < 10) {
                sbTime.append('0');
            }
            sbTime.append(this.seconds);
        } else {
            if (this.hours > 23) {
                throw new fpFormatException("Value will not format to TIME. Hours value is greater than 23");
            }
            if (hourLen < 2) {
                sbTime.append('0');
            }
            sbTime.append(this.hours);
            sbTime.append(":");
            if (this.minutes < 10) {
                sbTime.append('0');
            }
            sbTime.append(this.minutes);
            sbTime.append(":");
            if (this.seconds < 10) {
                sbTime.append('0');
            }
            sbTime.append(this.seconds);
        }
        return sbTime.toString();
    }
}

