#!/bin/ksh
# @(#) ck.prc - check if processing tables are saved in ASCII or ENCODED.
# @(#) ck.tok - check if processing tables are newer than tok tables.
# Bob Stockler - 11/30/2000
#      Following changes made by Jerry Rains
#      Changed logic from ( -z $PFDATA || -z $PFDIR ) to && - 1/31/01
#      Wrote routine to use 'type' to find fastest awk - 1/31/01
#      Wrote whence script to use with Linux - 2/20/01
PROG=${0##*/}
fPfile=$1
[ "$2" = "-q" ] && quiet="yes"

#jmr Test to see if whence is good function.  If not use whence script.
tst=`whence od` 2>/dev/null
[ -n "$tst" ] && WHENCE=whence || WHENCE=$instdir/whence

# This program writes its output to the standard output.

Usage1="
  Usage:  $PROG [ filepro_File_Name ]\n
  Reports ASCII or ENCODED for all processing tables
  in the current directory or in that of the filePro
  file given as its argument.\n"

Usage2="
  Usage:  $PROG [ filepro_File_Name ]\n
  Reports untokenized processing tables and those newer than
  their tokenized versions for all processing tables in the
  current directory or in that of the filePro file given as
  its argument.\n"

# See if any of PFPROG, PFDATA, & PFDIR are not in the environment;
# prefer PFPROG, PFDATA & PFDIR, but accept FPPROG, FPDATA or FPDIR.
# If any are missing, read /etc/default/fppath putting defaults for
# PFPROG, PFDATA & PFDIR in the array elements FP[1], FP[2] & FP[3]:
: ${PFPROG:=$FPPROG} ${PFDATA:=$FPDATA} ${PFDIR:=$FPDIR} ${PFDSK:=$FPDSK}
[[ -z $PFPROG || ( -z $PFDATA && -z $PFDIR ) ]] && {
  [[ -r /etc/default/fppath ]] && { typeset -i i=0
    while read ; do i=`expr $i + 1` ; FP[i]=$REPLY ; done </etc/default/fppath
  } || {
    $ECHO "\n  $PROG:  Can't read \"/etc/default/fppath\".\n" >2 ; exit 2
  }
}
# Put the filePro program's directory in the PATH:
# See if the filePro files directory can be found:
[[ -d ${PFDATA=${FP[2]}}${PFDIR=${FP[3]}}/filepro ]] || {
  $ECHO "\n  $PROG:  Can't find the filePro Files.\n" >2 ; exit 2
}
[[ -w $PFPROG/fp/lib/errmsg ]] || {
  $ECHO "\n  $PROG:  Must be run by \"root\" or \"filepro\".\n" >2 ; exit 2
}
# use the fastest AWK in the user's PATH:
# Linux chokes on whence.
: ${AWK:=$($WHENCE mawk)}
: ${AWK:=$($WHENCE gawk)}
: ${AWK:=$($WHENCE nawk)}
: ${AWK:=$($WHENCE awk)}
[ "$AWK" ] || AWK="awk"

[[ -n $fPfile ]] && {
  [[ -r $PFDATA$PFDIR/filepro/$fPfile/map ]] && {
    cd $PFDATA$PFDIR/filepro/$fPfile
  } || {
    case $PROG in
      *ck.prc) $ECHO "$Usage1" ;;
      *ck.tok) $ECHO "$Usage2" ;;
    esac
    exit 0
  }
} || fPfile=$PWD

[[ $(echo prc.*) = "prc.*" ]] && {
  $ECHO "
  $PROG: There are no processing tables in \"$fPfile\".\n" >2 ; exit 2
}
# typeset -L28 Prc Tok
typeset -i CNT=0
# Regular expression to match processing tables saved in ASCII format:
RE="^[ -9;-~]*:[ -9;-~]*:[ -9;-~]*:[ -~]*$"
for PRC in prc.*
do [[ -s $PRC ]] || continue
   case $PROG in
     *ck.prc) :
       tr -d "\000" <$PRC |
       $AWK -v PRC="${PRC#prc.}" \
            -v RE="$RE" \
            -v PFNAME=$1 \
            -v ASC="$PFDATA$PFDIR/ASCII_ENCODED" \
            -v ENC="$PFDATA$PFDIR/ENCODED" \
            -v QUIET=$quiet \
       'BEGIN { fmt = "%7s - %s\n" }
         { if ( $0 ~ RE ) printf fmt, "ASCII", PRC
# Changed else to write ENCODED to ENCODED file for 'search' - jmr
           else {
               printf fmt, "ENCODED", PRC
               if ( QUIET = "yes" ) {
                   print "ENCODED" > (ASC)
                   print PFNAME, PRC >> (ENC)
                   };
               }
           exit 0
         }' ;;
     *ck.tok) :
        [[ -x $PFPROG/fp/rcabe ]] || {
          $ECHO "
  $PROG: This program is meaningless without \"rcabe\".\n" >2 ; exit 2
        }
        TOK="tok.${PRC#prc.}" Prc="${PRC#prc.}"
        [[ -e $TOK ]] || {
          (( CNT += 1 ))
          $ECHO "$Prc - NOT Tokenized"
          continue
        }
        [[ $PRC -nt $TOK ]] && {
          (( CNT += 1 ))
          $ECHO "$Prc - NEWER than its \"tok\" table"
        }
   esac
done

case $PROG in
  *ck.tok) (( CNT == 0 )) && {
             $ECHO "\n  All tokenization tables are up to date.\n"
           } ;;
esac
exit 0

# EOF 'ck.prc' & 'ck.tok' - Bob Stockler - Thu Nov 30 12:12:12 EST 2000
