/* showlock.c -- shows the locks on a file.
 *
 *	To compile:
 *		cc -o showlock showlock.c
 *
 *	Usage:	showlock [-] filename [filename...]
 *
 *	If "-" is included, only the number of locks is shown,
 *	otherwise, for each lock, the following is show:
 *
 *		start offset (in hex)
 *		length (in hex)
 *		pid of owner (in decimal)
 */

#include <stdio.h>
#include <fcntl.h>

#ifndef F_GETLK
{ *** error -- need F_GETLK *** ; }
#endif

int summary = 0;

main(argc,argv)
	int argc;
	char *argv[];
	{
	char **names;
	int count;

	if ( argc < 2 )
		{
	    usage:
		fprintf(stderr,"Usage:  showlock [-] filename [filename ...]\n");
		exit(1);
		}

	names = argv+1;
	count = argc-1;

	if ( argv[1][0] == '-' )
		{
		summary = 1;
		if ( argc < 3 )
			goto usage;
		names++;
		count--;
		}

	while ( count-- )
		{
		DoIt(*names++);
		}
	}

DoIt(name)
	char *name;
	{
	struct flock lock;
	long numlock;
	long offset;
	int fd;

	if ( (fd = open(name,O_RDWR)) < 0 )
		{
		perror(name);
		return(0);
		}

	printf("%s:",name);

	numlock = 0;
	offset = 0L;
	for(;;)
		{
		lock.l_type = F_WRLCK;
		lock.l_whence = 0;	/* start of file */
		lock.l_start = offset;
		lock.l_len = 0;		/* to eof */
		if ( fcntl(fd,F_GETLK,&lock) < 0 )
			{
			perror("fcntl");
			close(fd);
			return(0);
			}
		if ( lock.l_type == F_UNLCK )
			break;
		numlock++;
		if ( !summary )
			printf("\n    %08lx %08lx %5d",
				lock.l_start,lock.l_len,lock.l_pid);
		if ( lock.l_len == 0 )
			break;
		offset = lock.l_start + lock.l_len;
		}

	if ( summary )
		printf("  %ld\n",numlock);
	else
		printf("\n");
	close(fd);
	}

